use crate::{from_stream, to_stream, FromStream, ReadError, ToStream, WriteError};

use std::io::{Read, Write};

impl<S, T: ToStream<S>> ToStream<S> for Box<T> {
    fn to_stream<W: Write>(&self, stream: &mut W) -> Result<(), WriteError> {
        (&**self).to_stream(stream)
    }
}

impl<S, T: FromStream<S>> FromStream<S> for Box<T> {
    fn from_stream<R: Read>(stream: &mut R) -> Result<Self, ReadError> {
        Ok(Box::new(from_stream(stream)?))
    }
}

impl<S, T: ToStream<S>> ToStream<S> for Option<T> {
    fn to_stream<W: Write>(&self, stream: &mut W) -> Result<(), WriteError> {
        match self {
            None => to_stream::<S, _, _>(&false, stream),
            Some(value) => {
                to_stream::<S, _, _>(&true, stream)?;
                value.to_stream(stream)
            }
        }
    }
}

impl<S, T: FromStream<S>> FromStream<S> for Option<T> {
    fn from_stream<R: Read>(stream: &mut R) -> Result<Self, ReadError> {
        Ok(match from_stream::<S, bool, _>(stream)? {
            false => None,
            true => Some(from_stream(stream)?),
        })
    }
}

impl<S, T: ToStream<S>, E: ToStream<S>> ToStream<S> for Result<T, E> {
    fn to_stream<W: Write>(&self, stream: &mut W) -> Result<(), WriteError> {
        match self {
            Err(err) => {
                to_stream::<S, _, _>(&false, stream)?;
                err.to_stream(stream)
            }
            Ok(value) => {
                to_stream::<S, _, _>(&true, stream)?;
                value.to_stream(stream)
            }
        }
    }
}

impl<S, T: FromStream<S>, E: FromStream<S>> FromStream<S> for Result<T, E> {
    fn from_stream<R: Read>(stream: &mut R) -> Result<Self, ReadError> {
        Ok(match from_stream::<S, bool, _>(stream)? {
            false => Err(from_stream(stream)?),
            true => Ok(from_stream(stream)?),
        })
    }
}
