use crate::{FromStream, ReadError, ToStream, WriteError};

use std::io::{Read, Write};

impl<S> ToStream<S> for bool {
    fn to_stream<W: Write>(&self, stream: &mut W) -> Result<(), WriteError> {
        let bytes = [if *self { 1 } else { 0 }];
        if stream.write(bytes.as_ref()).is_err() {
            Err(WriteError::Stream)
        } else {
            Ok(())
        }
    }
}

impl<S> FromStream<S> for bool {
    fn from_stream<R: Read>(stream: &mut R) -> Result<Self, ReadError> {
        let mut bytes = [0; 1];

        if stream.read_exact(&mut bytes).is_err() {
            Err(ReadError::Stream)
        } else {
            match bytes[0] {
                0 => Ok(false),
                1 => Ok(true),
                _ => Err(ReadError::Invalid),
            }
        }
    }
}
