use crate::{from_stream, FromStream, ReadError, ToStream, WriteError};

use std::io::{Read, Write};

impl<S, T: ToStream<S>, const N: usize> ToStream<S> for [T; N] {
    fn to_stream<W: Write>(&self, stream: &mut W) -> Result<(), WriteError> {
        for element in self {
            element.to_stream(stream)?
        }

        Ok(())
    }
}

impl<S, T: FromStream<S> + Default + Copy, const N: usize> FromStream<S> for [T; N] {
    fn from_stream<R: Read>(stream: &mut R) -> Result<Self, ReadError> {
        let mut result = [Default::default(); N];

        for i in 0..N {
            result[i] = from_stream(stream)?
        }

        Ok(result)
    }
}
