use chrono::serde::ts_seconds;
use chrono::Utc;

use serde::{Deserialize, Serialize};

use crate::Variant;

#[derive(Clone, Debug, Deserialize, Serialize)]
pub struct Message {
    pub key: String,

    pub body: Variant,

    #[serde(with = "ts_seconds")]
    #[serde(default = "chrono::Utc::now")]
    pub time: chrono::DateTime<Utc>,
}

#[derive(Clone, Debug, Deserialize, Serialize)]
pub struct BatchMessage {
    pub messages: Vec<Message>,
}

#[derive(Clone, Debug, Serialize)]
pub struct GenericMessage<'a, 'b, T: Serialize> {
    pub key: &'a str,

    pub body: &'b T,

    #[serde(with = "ts_seconds")]
    #[serde(default = "chrono::Utc::now")]
    pub time: chrono::DateTime<Utc>,
}
