use std::collections::HashMap;

use serde::{Deserialize, Serialize};

use crate::Variant;

#[derive(Deserialize, Serialize)]
pub struct LoginRequest {
    pub email: String,
    pub password: String,
}

#[derive(Deserialize, Serialize)]
pub struct LoginResponse {
    pub token: String,
}

#[derive(Clone, Debug, Deserialize, Serialize)]
pub struct User {
    pub id: String,
    pub permissions: Vec<String>,
    pub services: HashMap<String, Variant>,
}
