use std::collections::HashMap;

use serde::{Deserialize, Serialize};

#[derive(Clone, Debug, Deserialize, Serialize)]
#[serde(untagged)]
pub enum Variant {
    Str(String),
    Int(i32),
    Double(f64),
    Bool(bool),
    Seq(Vec<Variant>),
    Map(HashMap<String, Variant>),
}
