#[cfg(test)]
use super::strip_dag;

#[test]
fn strips_dag_successfully() {
    let original_dag = "a-b,b-c,c-d,c-d";
    let vertice_to_strip = "d";

    let expected_dag_result = "a-b,b-c";
    let stripped_dag = strip_dag(original_dag, vertice_to_strip);

    assert_eq!(expected_dag_result, stripped_dag);
}
#[test]
fn nothing_to_strip_just_remove_duplicates() {
    let original_dag = "a-b,b-c,c-d,c-d";

    let vertice_to_strip = "x";

    let expected_dag_result = "a-b,b-c,c-d";
    let stripped_dag = strip_dag(original_dag, vertice_to_strip);

    assert_eq!(expected_dag_result, stripped_dag);
}

#[test]
fn strip_alphabetically() {
    let original_dag = "a-b,b-d,d,d";
    let vertice_to_strip = "c";

    let expected_dag_result = "a-b,b-d";
    // What is the utility of non-branched vertices? (single vertices)
    let stripped_dag = strip_dag(original_dag, vertice_to_strip);

    assert_eq!(expected_dag_result, stripped_dag);
}
