use clap::{crate_description, crate_name, crate_version, App, Arg};

mod strip_vertice;
use strip_vertice::strip_dag;

fn main() {
    let matches = App::new("Vertex")
        .name(crate_name!())
        .about(crate_description!())
        .version(crate_version!())
        .arg(
            Arg::with_name("in")
                .short("in")
                .long("in")
                .help("The provided DAG (e.g a-b,b-c,c-d)")
                .required(true)
                .takes_value(true),
        )
        .arg(
            Arg::with_name("strip")
                .short("s")
                .long("strip")
                .help("The character to strip (e.g \"c\")")
                .required(true)
                .takes_value(true),
        )
        .get_matches();

    let vertex = matches
        .value_of("in")
        .expect("A valid DAG needs to be provided");
    let strip = matches
        .value_of("strip")
        .expect("A valid character to strip needs to be provided");

    let stripped_dag = strip_dag(vertex, strip);

    println!("The new DAG is : {}", stripped_dag)
}
