use std::fs::File;
use std::io::BufReader;
use std::io::Read;
use std::time::Instant;

use dade::json_load;

fn dade_load(json: &str) {
    let ret = json_load(json);
    assert!(ret.is_ok(), "{}", ret.err().unwrap());
}

fn main() {
    let file = File::open("./benches/twitter.json").unwrap();
    let mut buf_reader = BufReader::new(file);
    let mut contents = String::new();
    buf_reader.read_to_string(&mut contents).unwrap();
    let json = contents.as_str();
    let now = Instant::now();
    dade_load(json);
    let elapsed_time = now.elapsed();
    println!(
        "Running slow_function() took {} micro.",
        elapsed_time.as_micros()
    );
}
