use dade::{json_dump, json_load};
use std::fs::File;
use std::io::{BufReader, Read};

fn main() {
    let file = File::open("./tests/data/parsing/n_string_unescaped_crtl_char.json").unwrap();
    let mut buf_reader = BufReader::new(file);
    let mut contents = String::new();
    buf_reader.read_to_string(&mut contents).unwrap();
    let ret = json_load(contents.as_str());
    assert!(ret.is_ok(), "{:?}", ret.err());
    assert_eq!(json_dump(&ret.as_ref().unwrap(), false), contents);
}
