use dade::JsonValue;
use indexmap::IndexMap;

trait ToSchema {
    fn schema() -> JsonValue;
}

trait ToSchema2 {
    fn schema() -> JsonValue;
}

impl ToSchema for () {
    fn schema() -> JsonValue {
        JsonValue::Object(IndexMap::from([(
            "type".to_string(),
            JsonValue::String("null".to_string()),
        )]))
    }
}

macro_rules! int_schema {
    ( $( $i:ident ),* ) => {
        $(
            impl ToSchema for $i {
                fn schema() -> JsonValue {
                    JsonValue::Object(IndexMap::from([(
                        "type".to_string(),
                        JsonValue::String("integer".to_string()),
                    )]))
                }
            }
        )*
    };
}
macro_rules! int_schema2 {
    ( $( $i:ident ),* ) => {
        $(
            impl ToSchema2 for $i {
                fn schema() -> JsonValue {
                    JsonValue::Object(IndexMap::from([(
                        "type".to_string(),
                        JsonValue::String("integer".to_string()),
                    )]))
                }
            }
        )*
    };
}

int_schema!(u8, u16);
int_schema2!(u8, u16);

fn main() {
    println!("{}", <u8 as ToSchema>::schema().to_string());
    println!("{}", <u16 as ToSchema>::schema().to_string());
}
