use dade::Model;
use dade_derive::model;

#[model]
struct User {
    id: u64,
    #[field(alias = "FirstName")]
    first_name: String,
    #[field(alias = "LastName")]
    last_name: String,
}

fn main() {
    let input = "{\"id\": 1, \"FirstName\": \"James\", \"LastName\": \"Smith\"}";
    let user = User::parse(input).unwrap();
    assert_eq!(user.first_name, "James");
    assert_eq!(user.last_name, "Smith");
    assert_eq!(
        user.json(false),
        "{\"id\":1,\"FirstName\":\"James\",\"LastName\":\"Smith\"}"
    );
    println!("Schema: {}", User::schema());
}
