use dade::Model;

struct Item {
    id: u64,
    name: String,
    value: u128,
    related_items: Option<Vec<Box<Item>>>,
}
impl dade::ToJsonValue for Item {
    fn to_json_value(&self) -> dade::JsonValue {
        dade::JsonValue::Object(indexmap::map::IndexMap::from([
            ("id".to_string(), dade::ToJsonValue::to_json_value(&self.id)),
            (
                "name".to_string(),
                dade::ToJsonValue::to_json_value(&self.name),
            ),
            (
                "value".to_string(),
                dade::ToJsonValue::to_json_value(&self.value),
            ),
            (
                "related_items".to_string(),
                dade::ToJsonValue::to_json_value(&self.related_items),
            ),
        ]))
    }
}
impl dade::FromJsonValue for Item {
    fn from_json_value(value: &dade::JsonValue) -> dade::Result<Self> {
        match value {
            dade::JsonValue::Object(dict) => {
                let id: u64 = match dict.get("id") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, id")),
                };
                if !(id >= 1) {
                    return Err(dade::Error::new("invalid number"));
                }
                let name: String = match dict.get("name") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, name")),
                };
                if !(name.len() >= 1 && name.len() <= 100) {
                    return Err(dade::Error::new("invalid string"));
                }
                let value: u128 = match dict.get("value") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, value")),
                };
                let related_items: Option<Vec<Box<Item>>> = match dict.get("related_items") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => None,
                };
                Ok(Item {
                    id,
                    name,
                    value,
                    related_items,
                })
            }
            _ => Err(dade::Error::new("expect `JsonValue::Object`")),
        }
    }
}
impl dade::RegisterSchema for Item {
    fn register_schema(
        defs: &mut indexmap::map::IndexMap<String, dade::JsonValue>,
    ) -> dade::JsonValue {
        if !defs.contains_key(&"Item".to_string()) {
            defs.insert("Item".to_string(), dade::JsonValue::Null);
            let json_value = dade::JsonValue::Object(indexmap::map::IndexMap::from([
                (
                    "title".to_string(),
                    dade::JsonValue::String(dade::ToTitle::to_title("Item")),
                ),
                (
                    "type".to_string(),
                    dade::JsonValue::String("object".to_string()),
                ),
                (
                    "properties".to_string(),
                    dade::JsonValue::Object(indexmap::map::IndexMap::from([
                        ("id".to_string(), {
                            let mut s = <u64 as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("id")),
                                );
                                dict.insert(
                                    "minimum".to_string(),
                                    dade::JsonValue::Number(dade::Number::from(1)),
                                );
                            }
                            s
                        }),
                        ("name".to_string(), {
                            let mut s = <String as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("name")),
                                );
                                dict.insert(
                                    "minLength".to_string(),
                                    dade::JsonValue::Number(dade::Number::from(1)),
                                );
                                dict.insert(
                                    "maxLength".to_string(),
                                    dade::JsonValue::Number(dade::Number::from(100)),
                                );
                            }
                            s
                        }),
                        ("value".to_string(), {
                            let mut s = <u128 as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("value")),
                                );
                            }
                            s
                        }),
                        ("related_items".to_string(), {
                            let mut s =
                                <Option<Vec<Box<Item>>> as dade::RegisterSchema>::register_schema(
                                    defs,
                                );
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title(
                                        "related_items",
                                    )),
                                );
                            }
                            s
                        }),
                    ])),
                ),
                (
                    "required".to_string(),
                    dade::JsonValue::Array(Vec::from([
                        dade::JsonValue::String("id".to_string()),
                        dade::JsonValue::String("name".to_string()),
                        dade::JsonValue::String("value".to_string()),
                    ])),
                ),
            ]));
            defs[&"Item".to_string()] = json_value;
        }
        dade::JsonValue::Object(indexmap::map::IndexMap::from([(
            "$ref".to_string(),
            dade::JsonValue::String("#/definitions/Item".to_string()),
        )]))
    }
}
struct Cart {
    id: u64,
    name: User,
    items: Vec<Item>,
}
impl dade::ToJsonValue for Cart {
    fn to_json_value(&self) -> dade::JsonValue {
        dade::JsonValue::Object(indexmap::map::IndexMap::from([
            ("id".to_string(), dade::ToJsonValue::to_json_value(&self.id)),
            (
                "name".to_string(),
                dade::ToJsonValue::to_json_value(&self.name),
            ),
            (
                "items".to_string(),
                dade::ToJsonValue::to_json_value(&self.items),
            ),
        ]))
    }
}
impl dade::FromJsonValue for Cart {
    fn from_json_value(value: &dade::JsonValue) -> dade::Result<Self> {
        match value {
            dade::JsonValue::Object(dict) => {
                let id: u64 = match dict.get("id") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, id")),
                };
                if !(id >= 1) {
                    return Err(dade::Error::new("invalid number"));
                }
                let name: User = match dict.get("name") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, name")),
                };
                let items: Vec<Item> = match dict.get("items") {
                    Some(val) => dade::FromJsonValue::from_json_value(val)?,
                    None => return Err(dade::Error::new("not found key, items")),
                };
                Ok(Cart { id, name, items })
            }
            _ => Err(dade::Error::new("expect `JsonValue::Object`")),
        }
    }
}
impl dade::RegisterSchema for Cart {
    fn register_schema(
        defs: &mut indexmap::map::IndexMap<String, dade::JsonValue>,
    ) -> dade::JsonValue {
        if !defs.contains_key(&"Cart".to_string()) {
            defs.insert("Cart".to_string(), dade::JsonValue::Null);
            let json_value = dade::JsonValue::Object(indexmap::map::IndexMap::from([
                (
                    "title".to_string(),
                    dade::JsonValue::String(dade::ToTitle::to_title("Cart")),
                ),
                (
                    "type".to_string(),
                    dade::JsonValue::String("object".to_string()),
                ),
                (
                    "properties".to_string(),
                    dade::JsonValue::Object(indexmap::map::IndexMap::from([
                        ("id".to_string(), {
                            let mut s = <u64 as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("id")),
                                );
                                dict.insert(
                                    "minimum".to_string(),
                                    dade::JsonValue::Number(dade::Number::from(1)),
                                );
                            }
                            s
                        }),
                        ("name".to_string(), {
                            let mut s = <User as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("name")),
                                );
                            }
                            s
                        }),
                        ("items".to_string(), {
                            let mut s = <Vec<Item> as dade::RegisterSchema>::register_schema(defs);
                            if let dade::JsonValue::Object(ref mut dict) = s {
                                dict.insert(
                                    "title".to_string(),
                                    dade::JsonValue::String(dade::ToTitle::to_title("items")),
                                );
                            }
                            s
                        }),
                    ])),
                ),
                (
                    "required".to_string(),
                    dade::JsonValue::Array(Vec::from([
                        dade::JsonValue::String("id".to_string()),
                        dade::JsonValue::String("name".to_string()),
                        dade::JsonValue::String("items".to_string()),
                    ])),
                ),
            ]));
            defs[&"Cart".to_string()] = json_value;
        }
        dade::JsonValue::Object(indexmap::map::IndexMap::from([(
            "$ref".to_string(),
            dade::JsonValue::String("#/definitions/Cart".to_string()),
        )]))
    }
}
fn main() {
    // println!("Schema: {}", User::schema());
    println!("Schema: {}", Item::schema());
    // println!("Schema: {}", Cart::schema());
}
