use dade::Model;
use dade_derive::model;

#[model]
struct User {
    #[field(ge = 1)]
    id: u64,
    #[field(min_length = 1, max_length = 100)]
    name: String,
    #[field(default = "en")]
    lang: String,
    #[field(min_length = 1, max_length = 255, default = null)]
    url: Option<String>,
    #[field(default = false)]
    verified: bool,
}

#[model]
struct Item {
    // #[field(ge = 1)]
    id: u64,
    // #[field(min_length = 1, max_length = 100)]
    name: String,
    value: u128,
    related_items: Option<Vec<Box<Item>>>,
}

#[model]
struct Cart {
    #[field(ge = 1)]
    id: u64,
    name: User,
    items: Vec<Item>,
}

fn main() {
    let input = "{\"id\": 1, \"name\": \"James Smith\"}";
    let user = User::parse(input).unwrap();
    let output = user.json(false);
    assert_eq!(
        output,
        "{\"id\":1,\"name\":\"James Smith\",\"lang\":\"en\",\"url\":null,\"verified\":false}"
    );
    println!("Schema: {}", User::schema());
    println!("Schema: {}", Item::schema());
    println!("Schema: {}", Cart::schema());
    println!("Schema: {}", String::schema());
}
