use std::string::String;

fn main() {
    let space = '\u{1000}';

    let mut b = [0; 3];
    let result = space.encode_utf8(&mut b);

    println!("{}", space);
    println!("{}", result);
    println!("{:?}", b);

    let s = String::from_utf8(b.to_vec()).unwrap();
    println!("{}", s);
    println!("{}", space.escape_unicode());
    println!("{}", space.escape_default());

    let ss = "\\u1000";
    for c in ss.chars() {
        println!("{}", c);
    }

    println!("{:?}", char::from_u32(4096));
    println!("{:?}", char::from_u32(0x0C).unwrap());

    let mut s = String::with_capacity(10);
    let ss = s.clone();
    println!("{}", s.capacity());
    println!("{}", ss.capacity());
    s.push('a');
    let ss = s.clone();
    println!("{}", s.capacity());
    println!("{}", ss.capacity());

    for i in (0..4).rev() {
        println!("{}", i);
    }
}
