#![feature(test)]

extern crate test;

use test::Bencher;

use std::fs::File;
use std::io::BufReader;
use std::io::Read;

use dade::json_load;

use serde_json;

fn dade_load(json: &str) {
    let ret = json_load(json);
    assert!(ret.is_ok(), "{}", ret.err().unwrap());
}

#[bench]
fn bench_dade_load(b: &mut Bencher) {
    let file = File::open("./benches/twitter.json").unwrap();
    let mut buf_reader = BufReader::new(file);
    let mut contents = String::new();
    buf_reader.read_to_string(&mut contents).unwrap();
    let json = contents.as_str();
    b.iter(|| dade_load(json));
}

fn serde_load(json: &str) {
    let ret: serde_json::Result<serde_json::Value> = serde_json::from_str(json);
    assert!(ret.is_ok(), "{}", ret.err().unwrap());
}

#[bench]
fn bench_serde_load(b: &mut Bencher) {
    let file = File::open("./benches/twitter.json").unwrap();
    let mut buf_reader = BufReader::new(file);
    let mut contents = String::new();
    buf_reader.read_to_string(&mut contents).unwrap();
    let json = contents.as_str();
    b.iter(|| serde_load(json));
}
