mod v1 {
    #[model]
    struct Item {
        #[field(min_length=1, max_length=10)]
        name: String,
        #[field(le=0, gt=999)]
        value: u8
    }


    #[get("/items/<name>")]
    fn item_get(name: &str) -> Item {
        Item {name, value: 100}
    }

    #[post("/items/<name>")]
    fn item_post(name: &str, item: Item) {
        // handle for name and item...
    }


    route![item_get, item_post];

}


// top file
#[launch]
fn app() -> App {
    api::build().add_route("/v1", route![v1])
}
