

#[model]
struct Phone {
    #[field(min_length=1, max_length=10)]
    number: String
}

enum Language {
    English,
    Chinese,
    Spanish,
    Japanese,
}

#[model]
struct User {
    #[field(min_length=1, max_length=10)]
    name: String,
    #[field(le=0, gt=999)]
    age: u8,
    #[field(min_items=1)]
    phones: Vec<Phone>,
    address: Option<String>,
    #[field(default=Language::English)]
    language: Language
}


trait Model {
    fn schema(&self) -> String;
    fn json(&self) -> String;
    fn parse(json: &str) -> Self;
}
