#![feature(test)]

extern crate test;

use test::Bencher;

use std::fs::File;
use std::io::BufReader;
use std::io::Read;

use dade::Model;
use dade_derive::model;

#[model]
struct Metadata {
    #[field]
    result_type: String,
    #[field]
    iso_language_code: String,
}

#[model]
struct UserEntitiesDescription {
    #[field]
    urls: Vec<Url>,
}

#[model]
struct UserEntitiesUrl {
    #[field]
    urls: Vec<Url>,
}

#[model]
struct UserEntities {
    #[field]
    url: Option<UserEntitiesUrl>,
    #[field]
    description: UserEntitiesDescription,
}

#[model]
struct User {
    #[field]
    id: u128,
    #[field]
    id_str: String,
    #[field]
    name: String,
    #[field]
    screen_name: String,
    #[field]
    location: String,
    #[field]
    description: String,
    #[field]
    url: Option<String>,
    #[field]
    entities: UserEntities,
    #[field]
    protected: bool,
    #[field]
    followers_count: u128,
    #[field]
    friends_count: u128,
    #[field]
    listed_count: u128,
    #[field]
    created_at: String,
    #[field]
    favourites_count: u128,
    #[field]
    utc_offset: Option<i32>,
    #[field]
    time_zone: Option<String>,
    #[field]
    geo_enabled: bool,
    #[field]
    verified: bool,
    #[field]
    statuses_count: u128,
    #[field]
    lang: String,
    #[field]
    contributors_enabled: bool,
    #[field]
    is_translator: bool,
    #[field]
    is_translation_enabled: bool,
    #[field]
    profile_background_color: String,
    #[field]
    profile_background_image_url: String,
    #[field]
    profile_background_image_url_https: String,
    #[field]
    profile_background_tile: bool,
    #[field]
    profile_image_url: String,
    #[field]
    profile_image_url_https: String,
    #[field]
    profile_banner_url: Option<String>,
    #[field]
    profile_link_color: String,
    #[field]
    profile_sidebar_border_color: String,
    #[field]
    profile_sidebar_fill_color: String,
    #[field]
    profile_text_color: String,
    #[field]
    profile_use_background_image: bool,
    #[field]
    default_profile: bool,
    #[field]
    default_profile_image: bool,
    #[field]
    following: bool,
    #[field]
    follow_request_sent: bool,
    #[field]
    notifications: bool,
}

#[model]
struct UserMention {
    #[field]
    screen_name: String,
    #[field]
    name: String,
    #[field]
    id: u128,
    #[field]
    id_str: String,
    #[field]
    indices: Vec<u128>,
}

#[model]
struct Hashtag {
    #[field]
    text: String,
    #[field]
    indices: Vec<u128>,
}

#[model]
struct Url {
    #[field]
    url: String,
    #[field]
    expanded_url: String,
    #[field]
    display_url: String,
    #[field]
    indices: Vec<u128>,
}

#[model]
struct Size {
    #[field]
    w: u128,
    #[field]
    h: u128,
    #[field]
    resize: String,
}

#[model]
struct Sizes {
    #[field]
    large: Size,
    #[field]
    medium: Size,
    #[field]
    thumb: Size,
    #[field]
    small: Size,
}

#[model]
struct Media {
    #[field]
    id: u128,
    #[field]
    id_str: String,
    #[field]
    indices: Vec<u128>,
    #[field]
    media_url: String,
    #[field]
    media_url_https: String,
    #[field]
    url: String,
    #[field]
    display_url: String,
    #[field]
    expanded_url: String,
    #[field]
    media_type: Option<String>,
    #[field]
    sizes: Sizes,
    #[field]
    source_status_id: Option<u128>,
    #[field]
    source_status_id_str: Option<String>,
}

#[model]
struct StatusEntities {
    #[field]
    hashtags: Vec<Hashtag>,
    #[field]
    symbols: Vec<String>,
    #[field]
    urls: Vec<Url>,
    #[field]
    user_mentions: Vec<UserMention>,
    #[field]
    media: Option<Vec<Media>>,
}

#[model]
struct Status {
    #[field]
    metadata: Metadata,
    #[field]
    created_at: String,
    #[field]
    id: u128,
    #[field]
    id_str: String,
    #[field]
    text: String,
    #[field]
    source: String,
    #[field]
    truncated: bool,
    #[field]
    in_reply_to_status_id: Option<u128>,
    #[field]
    in_reply_to_status_id_str: Option<String>,
    #[field]
    in_reply_to_user_id: Option<u128>,
    #[field]
    in_reply_to_user_id_str: Option<String>,
    #[field]
    in_reply_to_screen_name: Option<String>,
    #[field]
    user: User,
    #[field]
    geo: (),
    #[field]
    coordinates: (),
    #[field]
    place: (),
    #[field]
    contributors: (),
    #[field]
    retweeted_status: Option<Box<Status>>,
    #[field]
    retweet_count: u128,
    #[field]
    favorite_count: u128,
    #[field]
    entities: StatusEntities,
    #[field]
    favorited: bool,
    #[field]
    retweeted: bool,
    #[field]
    possibly_sensitive: Option<bool>,
    #[field]
    lang: String,
}

#[model]
struct SearchMetadata {
    #[field]
    completed_in: f32,
    #[field]
    max_id: u128,
    #[field]
    max_id_str: String,
    #[field]
    next_results: String,
    #[field]
    query: String,
    #[field]
    refresh_url: String,
    #[field]
    count: u128,
    #[field]
    since_id: u128,
    #[field]
    since_id_str: String,
}

#[model]
struct Twitter {
    #[field]
    statuses: Vec<Status>,
    #[field]
    search_metadata: SearchMetadata,
}

fn read_twitter(json: &str) {
    let ret = Twitter::parse(json);
    assert!(ret.is_ok(), "{}", ret.err().unwrap());
}

#[bench]
fn bench_read_twitter(b: &mut Bencher) {
    let file = File::open("./benches/bk.json").unwrap();
    let mut buf_reader = BufReader::new(file);
    let mut contents = String::new();
    buf_reader.read_to_string(&mut contents).unwrap();
    let json = contents.as_str();
    b.iter(|| read_twitter(json));
}
