#![doc = "Peripheral access API for DA14531 microcontrollers (generated using svd2rust v0.22.1 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.22.1/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[doc = r"Number available in the NVIC for configuring priority"]
pub const NVIC_PRIO_BITS: u8 = 3;
#[cfg(feature = "rt")]
pub use self::Interrupt as interrupt;
pub use cortex_m::peripheral::Peripherals as CorePeripherals;
pub use cortex_m::peripheral::{CBP, CPUID, DCB, DWT, FPB, FPU, ITM, MPU, NVIC, SCB, SYST, TPIU};
#[cfg(feature = "rt")]
pub use cortex_m_rt::interrupt;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {}
#[doc(hidden)]
pub union Vector {
    _handler: unsafe extern "C" fn(),
    _reserved: u32,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[link_section = ".vector_table.interrupts"]
#[no_mangle]
pub static __INTERRUPTS: [Vector; 0] = [];
#[doc = r"Enumeration of all the interrupts."]
#[derive(Copy, Clone, Debug, PartialEq, Eq)]
pub enum Interrupt {}
unsafe impl cortex_m::interrupt::InterruptNumber for Interrupt {
    #[inline(always)]
    fn number(self) -> u16 {
        match self {}
    }
}
#[doc = "Cortex M0 SysTick registers"]
pub struct SYSTICK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYSTICK {}
impl SYSTICK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_tick::RegisterBlock = 0xe000_e010 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_tick::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYSTICK {
    type Target = sys_tick::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYSTICK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYSTICK").finish()
    }
}
#[doc = "Cortex M0 SysTick registers"]
pub mod sys_tick;
#[doc = "adplldig registers"]
pub struct ADPLLDIG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ADPLLDIG {}
impl ADPLLDIG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const adplldig::RegisterBlock = 0x4000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const adplldig::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ADPLLDIG {
    type Target = adplldig::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ADPLLDIG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ADPLLDIG").finish()
    }
}
#[doc = "adplldig registers"]
pub mod adplldig;
#[doc = "ANAMISC registers"]
pub struct ANAMISC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for ANAMISC {}
impl ANAMISC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const anamisc::RegisterBlock = 0x5000_1600 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const anamisc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for ANAMISC {
    type Target = anamisc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for ANAMISC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("ANAMISC").finish()
    }
}
#[doc = "ANAMISC registers"]
pub mod anamisc;
#[doc = "BLE registers"]
pub struct BLE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for BLE {}
impl BLE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ble::RegisterBlock = 0x4000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ble::RegisterBlock {
        Self::PTR
    }
}
impl Deref for BLE {
    type Target = ble::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for BLE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("BLE").finish()
    }
}
#[doc = "BLE registers"]
pub mod ble;
#[doc = "CHIP_VERSION registers"]
pub struct CHIP_VERSION {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CHIP_VERSION {}
impl CHIP_VERSION {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const chip_version::RegisterBlock = 0x5000_3200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const chip_version::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CHIP_VERSION {
    type Target = chip_version::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CHIP_VERSION {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CHIP_VERSION").finish()
    }
}
#[doc = "CHIP_VERSION registers"]
pub mod chip_version;
#[doc = "CRG_AON registers"]
pub struct CRG_AON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRG_AON {}
impl CRG_AON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crg_aon::RegisterBlock = 0x5000_0300 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crg_aon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRG_AON {
    type Target = crg_aon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRG_AON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRG_AON").finish()
    }
}
#[doc = "CRG_AON registers"]
pub mod crg_aon;
#[doc = "CRG_TIM registers"]
pub struct CRG_TIM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRG_TIM {}
impl CRG_TIM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crg_tim::RegisterBlock = 0x5000_4200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crg_tim::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRG_TIM {
    type Target = crg_tim::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRG_TIM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRG_TIM").finish()
    }
}
#[doc = "CRG_TIM registers"]
pub mod crg_tim;
#[doc = "CRG_TOP registers"]
pub struct CRG_TOP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CRG_TOP {}
impl CRG_TOP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const crg_top::RegisterBlock = 0x5000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const crg_top::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CRG_TOP {
    type Target = crg_top::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CRG_TOP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CRG_TOP").finish()
    }
}
#[doc = "CRG_TOP registers"]
pub mod crg_top;
#[doc = "GPADC registers"]
pub struct GPADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPADC {}
impl GPADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpadc::RegisterBlock = 0x5000_1500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpadc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPADC {
    type Target = gpadc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPADC").finish()
    }
}
#[doc = "GPADC registers"]
pub mod gpadc;
#[doc = "GPIO registers"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x5000_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "GPIO registers"]
pub mod gpio;
#[doc = "GPREG registers"]
pub struct GPREG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPREG {}
impl GPREG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpreg::RegisterBlock = 0x5000_3300 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpreg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPREG {
    type Target = gpreg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPREG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPREG").finish()
    }
}
#[doc = "GPREG registers"]
pub mod gpreg;
#[doc = "I2C registers"]
pub struct I2C {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2C {}
impl I2C {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2c::RegisterBlock = 0x5000_1300 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2c::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2C {
    type Target = i2c::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2C {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2C").finish()
    }
}
#[doc = "I2C registers"]
pub mod i2c;
#[doc = "KBRD registers"]
pub struct KBRD {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for KBRD {}
impl KBRD {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const kbrd::RegisterBlock = 0x5000_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const kbrd::RegisterBlock {
        Self::PTR
    }
}
impl Deref for KBRD {
    type Target = kbrd::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for KBRD {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("KBRD").finish()
    }
}
#[doc = "KBRD registers"]
pub mod kbrd;
#[doc = "MBIST_SRAM12 registers"]
pub struct MBIST_SRAM12 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MBIST_SRAM12 {}
impl MBIST_SRAM12 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mbist_sram12::RegisterBlock = 0x5000_3700 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mbist_sram12::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MBIST_SRAM12 {
    type Target = mbist_sram12::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MBIST_SRAM12 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MBIST_SRAM12").finish()
    }
}
#[doc = "MBIST_SRAM12 registers"]
pub mod mbist_sram12;
#[doc = "MBIST_SRAM3 registers"]
pub struct MBIST_SRAM3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for MBIST_SRAM3 {}
impl MBIST_SRAM3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const mbist_sram3::RegisterBlock = 0x5000_3800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const mbist_sram3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for MBIST_SRAM3 {
    type Target = mbist_sram3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for MBIST_SRAM3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("MBIST_SRAM3").finish()
    }
}
#[doc = "MBIST_SRAM3 registers"]
pub mod mbist_sram3;
#[doc = "OTPC registers"]
pub struct OTPC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OTPC {}
impl OTPC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const otpc::RegisterBlock = 0x07f4_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const otpc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OTPC {
    type Target = otpc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OTPC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OTPC").finish()
    }
}
#[doc = "OTPC registers"]
pub mod otpc;
#[doc = "PATCH registers"]
pub struct PATCH {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PATCH {}
impl PATCH {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const patch::RegisterBlock = 0x4008_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const patch::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PATCH {
    type Target = patch::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PATCH {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PATCH").finish()
    }
}
#[doc = "PATCH registers"]
pub mod patch;
#[doc = "QUADEC registers"]
pub struct QUADEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for QUADEC {}
impl QUADEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const quadec::RegisterBlock = 0x5000_0200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const quadec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for QUADEC {
    type Target = quadec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for QUADEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("QUADEC").finish()
    }
}
#[doc = "QUADEC registers"]
pub mod quadec;
#[doc = "RFCU registers"]
pub struct RFCU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFCU {}
impl RFCU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfcu::RegisterBlock = 0x4000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfcu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFCU {
    type Target = rfcu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFCU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFCU").finish()
    }
}
#[doc = "RFCU registers"]
pub mod rfcu;
#[doc = "RFCU_POWER registers"]
pub struct RFCU_POWER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFCU_POWER {}
impl RFCU_POWER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfcu_power::RegisterBlock = 0x4000_1200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfcu_power::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFCU_POWER {
    type Target = rfcu_power::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFCU_POWER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFCU_POWER").finish()
    }
}
#[doc = "RFCU_POWER registers"]
pub mod rfcu_power;
#[doc = "RFMON registers"]
pub struct RFMON {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RFMON {}
impl RFMON {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rfmon::RegisterBlock = 0x5000_3500 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rfmon::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RFMON {
    type Target = rfmon::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RFMON {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RFMON").finish()
    }
}
#[doc = "RFMON registers"]
pub mod rfmon;
#[doc = "RTC registers"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x5000_4100 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "RTC registers"]
pub mod rtc;
#[doc = "SPI registers"]
pub struct SPI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI {}
impl SPI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi::RegisterBlock = 0x5000_1200 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI {
    type Target = spi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI").finish()
    }
}
#[doc = "SPI registers"]
pub mod spi;
#[doc = "SYS_WDOG registers"]
pub struct SYS_WDOG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYS_WDOG {}
impl SYS_WDOG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_wdog::RegisterBlock = 0x5000_3100 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_wdog::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYS_WDOG {
    type Target = sys_wdog::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYS_WDOG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYS_WDOG").finish()
    }
}
#[doc = "SYS_WDOG registers"]
pub mod sys_wdog;
#[doc = "TIMER0 registers"]
pub struct TIMER0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER0 {}
impl TIMER0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer0::RegisterBlock = 0x5000_3400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER0 {
    type Target = timer0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER0").finish()
    }
}
#[doc = "TIMER0 registers"]
pub mod timer0;
#[doc = "TIMER1 registers"]
pub struct TIMER1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER1 {}
impl TIMER1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer1::RegisterBlock = 0x5000_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER1 {
    type Target = timer1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER1").finish()
    }
}
#[doc = "TIMER1 registers"]
pub mod timer1;
#[doc = "UART registers"]
pub struct UART {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART {}
impl UART {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x5000_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART").finish()
    }
}
#[doc = "UART registers"]
pub mod uart;
#[doc = "UART2 registers"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart2::RegisterBlock = 0x5000_1100 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "UART2 registers"]
pub mod uart2;
#[doc = "WKUP registers"]
pub struct WKUP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for WKUP {}
impl WKUP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const wkup::RegisterBlock = 0x5000_0100 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const wkup::RegisterBlock {
        Self::PTR
    }
}
impl Deref for WKUP {
    type Target = wkup::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for WKUP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("WKUP").finish()
    }
}
#[doc = "WKUP registers"]
pub mod wkup;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "SYSTICK"]
    pub SYSTICK: SYSTICK,
    #[doc = "ADPLLDIG"]
    pub ADPLLDIG: ADPLLDIG,
    #[doc = "ANAMISC"]
    pub ANAMISC: ANAMISC,
    #[doc = "BLE"]
    pub BLE: BLE,
    #[doc = "CHIP_VERSION"]
    pub CHIP_VERSION: CHIP_VERSION,
    #[doc = "CRG_AON"]
    pub CRG_AON: CRG_AON,
    #[doc = "CRG_TIM"]
    pub CRG_TIM: CRG_TIM,
    #[doc = "CRG_TOP"]
    pub CRG_TOP: CRG_TOP,
    #[doc = "GPADC"]
    pub GPADC: GPADC,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "GPREG"]
    pub GPREG: GPREG,
    #[doc = "I2C"]
    pub I2C: I2C,
    #[doc = "KBRD"]
    pub KBRD: KBRD,
    #[doc = "MBIST_SRAM12"]
    pub MBIST_SRAM12: MBIST_SRAM12,
    #[doc = "MBIST_SRAM3"]
    pub MBIST_SRAM3: MBIST_SRAM3,
    #[doc = "OTPC"]
    pub OTPC: OTPC,
    #[doc = "PATCH"]
    pub PATCH: PATCH,
    #[doc = "QUADEC"]
    pub QUADEC: QUADEC,
    #[doc = "RFCU"]
    pub RFCU: RFCU,
    #[doc = "RFCU_POWER"]
    pub RFCU_POWER: RFCU_POWER,
    #[doc = "RFMON"]
    pub RFMON: RFMON,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "SPI"]
    pub SPI: SPI,
    #[doc = "SYS_WDOG"]
    pub SYS_WDOG: SYS_WDOG,
    #[doc = "TIMER0"]
    pub TIMER0: TIMER0,
    #[doc = "TIMER1"]
    pub TIMER1: TIMER1,
    #[doc = "UART"]
    pub UART: UART,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "WKUP"]
    pub WKUP: WKUP,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        cortex_m::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            SYSTICK: SYSTICK {
                _marker: PhantomData,
            },
            ADPLLDIG: ADPLLDIG {
                _marker: PhantomData,
            },
            ANAMISC: ANAMISC {
                _marker: PhantomData,
            },
            BLE: BLE {
                _marker: PhantomData,
            },
            CHIP_VERSION: CHIP_VERSION {
                _marker: PhantomData,
            },
            CRG_AON: CRG_AON {
                _marker: PhantomData,
            },
            CRG_TIM: CRG_TIM {
                _marker: PhantomData,
            },
            CRG_TOP: CRG_TOP {
                _marker: PhantomData,
            },
            GPADC: GPADC {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            GPREG: GPREG {
                _marker: PhantomData,
            },
            I2C: I2C {
                _marker: PhantomData,
            },
            KBRD: KBRD {
                _marker: PhantomData,
            },
            MBIST_SRAM12: MBIST_SRAM12 {
                _marker: PhantomData,
            },
            MBIST_SRAM3: MBIST_SRAM3 {
                _marker: PhantomData,
            },
            OTPC: OTPC {
                _marker: PhantomData,
            },
            PATCH: PATCH {
                _marker: PhantomData,
            },
            QUADEC: QUADEC {
                _marker: PhantomData,
            },
            RFCU: RFCU {
                _marker: PhantomData,
            },
            RFCU_POWER: RFCU_POWER {
                _marker: PhantomData,
            },
            RFMON: RFMON {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            SPI: SPI {
                _marker: PhantomData,
            },
            SYS_WDOG: SYS_WDOG {
                _marker: PhantomData,
            },
            TIMER0: TIMER0 {
                _marker: PhantomData,
            },
            TIMER1: TIMER1 {
                _marker: PhantomData,
            },
            UART: UART {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            WKUP: WKUP {
                _marker: PhantomData,
            },
        }
    }
}
