#[doc = "Register `HWR_CTRL_REG` reader"]
pub struct R(crate::R<HWR_CTRL_REG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HWR_CTRL_REG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<HWR_CTRL_REG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<HWR_CTRL_REG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `HWR_CTRL_REG` writer"]
pub struct W(crate::W<HWR_CTRL_REG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<HWR_CTRL_REG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<HWR_CTRL_REG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<HWR_CTRL_REG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DISABLE_HWR` reader - Disables the RST functionality on P00"]
pub struct DISABLE_HWR_R(crate::FieldReader<bool, bool>);
impl DISABLE_HWR_R {
    #[inline(always)]
    pub(crate) fn new(bits: bool) -> Self {
        DISABLE_HWR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DISABLE_HWR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DISABLE_HWR` writer - Disables the RST functionality on P00"]
pub struct DISABLE_HWR_W<'a> {
    w: &'a mut W,
}
impl<'a> DISABLE_HWR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !1) | (value as u16 & 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Disables the RST functionality on P00"]
    #[inline(always)]
    pub fn disable_hwr(&self) -> DISABLE_HWR_R {
        DISABLE_HWR_R::new((self.bits & 1) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Disables the RST functionality on P00"]
    #[inline(always)]
    pub fn disable_hwr(&mut self) -> DISABLE_HWR_W {
        DISABLE_HWR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Hardware Reset control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [hwr_ctrl_reg](index.html) module"]
pub struct HWR_CTRL_REG_SPEC;
impl crate::RegisterSpec for HWR_CTRL_REG_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [hwr_ctrl_reg::R](R) reader structure"]
impl crate::Readable for HWR_CTRL_REG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [hwr_ctrl_reg::W](W) writer structure"]
impl crate::Writable for HWR_CTRL_REG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets HWR_CTRL_REG to value 0"]
impl crate::Resettable for HWR_CTRL_REG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
