/* automatically generated by rust-bindgen 0.55.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage, Align> {
    storage: Storage,
    align: [Align; 0],
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage, align: [] }
    }
}
impl<Storage, Align> __BindgenBitfieldUnit<Storage, Align>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 31;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __LONG_DOUBLE_USES_FLOAT128: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const _BITS_TYPES_H: u32 = 1;
pub const __TIMESIZE: u32 = 64;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const _BITS_WCHAR_H: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const _BITS_STDINT_UINTN_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub const _INTTYPES_H: u32 = 1;
pub const ____gwchar_t_defined: u32 = 1;
pub const __PRI64_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const __PRIPTR_PREFIX: &'static [u8; 2usize] = b"l\0";
pub const PRId8: &'static [u8; 2usize] = b"d\0";
pub const PRId16: &'static [u8; 2usize] = b"d\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRId64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdLEAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST16: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST8: &'static [u8; 2usize] = b"d\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const PRIdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const PRIi8: &'static [u8; 2usize] = b"i\0";
pub const PRIi16: &'static [u8; 2usize] = b"i\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIi64: &'static [u8; 3usize] = b"li\0";
pub const PRIiLEAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST16: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST8: &'static [u8; 2usize] = b"i\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST32: &'static [u8; 3usize] = b"li\0";
pub const PRIiFAST64: &'static [u8; 3usize] = b"li\0";
pub const PRIo8: &'static [u8; 2usize] = b"o\0";
pub const PRIo16: &'static [u8; 2usize] = b"o\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIo64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoLEAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST16: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST8: &'static [u8; 2usize] = b"o\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const PRIoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const PRIu8: &'static [u8; 2usize] = b"u\0";
pub const PRIu16: &'static [u8; 2usize] = b"u\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIu64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuLEAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST16: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST8: &'static [u8; 2usize] = b"u\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const PRIuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const PRIx8: &'static [u8; 2usize] = b"x\0";
pub const PRIx16: &'static [u8; 2usize] = b"x\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIx64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxLEAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST16: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST8: &'static [u8; 2usize] = b"x\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const PRIxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const PRIX8: &'static [u8; 2usize] = b"X\0";
pub const PRIX16: &'static [u8; 2usize] = b"X\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRIX64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXLEAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST16: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIXLEAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST8: &'static [u8; 2usize] = b"X\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST32: &'static [u8; 3usize] = b"lX\0";
pub const PRIXFAST64: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"ld\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"li\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"lo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"lu\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"lx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"lX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNd64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNdLEAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST32: &'static [u8; 3usize] = b"ld\0";
pub const SCNdFAST64: &'static [u8; 3usize] = b"ld\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNi64: &'static [u8; 3usize] = b"li\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNiLEAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST32: &'static [u8; 3usize] = b"li\0";
pub const SCNiFAST64: &'static [u8; 3usize] = b"li\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNu64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNuLEAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST32: &'static [u8; 3usize] = b"lu\0";
pub const SCNuFAST64: &'static [u8; 3usize] = b"lu\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNo64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNoLEAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST32: &'static [u8; 3usize] = b"lo\0";
pub const SCNoFAST64: &'static [u8; 3usize] = b"lo\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNx64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNxLEAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST32: &'static [u8; 3usize] = b"lx\0";
pub const SCNxFAST64: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"ld\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"li\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"lo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"lu\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"lx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const _STDIO_H: u32 = 1;
pub const __GNUC_VA_LIST: u32 = 1;
pub const _____fpos_t_defined: u32 = 1;
pub const ____mbstate_t_defined: u32 = 1;
pub const _____fpos64_t_defined: u32 = 1;
pub const ____FILE_defined: u32 = 1;
pub const __FILE_defined: u32 = 1;
pub const __struct_FILE_defined: u32 = 1;
pub const _IO_EOF_SEEN: u32 = 16;
pub const _IO_ERR_SEEN: u32 = 32;
pub const _IO_USER_LOCK: u32 = 32768;
pub const _IOFBF: u32 = 0;
pub const _IOLBF: u32 = 1;
pub const _IONBF: u32 = 2;
pub const BUFSIZ: u32 = 8192;
pub const EOF: i32 = -1;
pub const SEEK_SET: u32 = 0;
pub const SEEK_CUR: u32 = 1;
pub const SEEK_END: u32 = 2;
pub const P_tmpdir: &'static [u8; 5usize] = b"/tmp\0";
pub const _BITS_STDIO_LIM_H: u32 = 1;
pub const L_tmpnam: u32 = 20;
pub const TMP_MAX: u32 = 238328;
pub const FILENAME_MAX: u32 = 4096;
pub const L_ctermid: u32 = 9;
pub const FOPEN_MAX: u32 = 16;
pub const HTS_PATH_SEPARATOR_CHAR: u8 = 58u8;
pub const HTS_PATH_SEPARATOR_STR: &'static [u8; 2usize] = b":\0";
pub const HTS_RESIZE_CLEAR: u32 = 1;
pub const HTS_IDX_DELIM: &'static [u8; 8usize] = b"##idx##\0";
pub const HTS_VERSION: u32 = 101002;
pub const HTS_IDX_NOCOOR: i32 = -2;
pub const HTS_IDX_START: i32 = -3;
pub const HTS_IDX_REST: i32 = -4;
pub const HTS_IDX_NONE: i32 = -5;
pub const HTS_FMT_CSI: u32 = 0;
pub const HTS_FMT_BAI: u32 = 1;
pub const HTS_FMT_TBI: u32 = 2;
pub const HTS_FMT_CRAI: u32 = 3;
pub const PRIhts_pos: &'static [u8; 3usize] = b"ld\0";
pub const HTS_IDX_SAVE_REMOTE: u32 = 1;
pub const HTS_IDX_SILENT_FAIL: u32 = 2;
pub const HTS_PARSE_THOUSANDS_SEP: u32 = 1;
pub const HTS_PARSE_ONE_COORD: u32 = 2;
pub const HTS_PARSE_LIST: u32 = 4;
pub const FT_UNKN: u32 = 0;
pub const FT_GZ: u32 = 1;
pub const FT_VCF: u32 = 2;
pub const FT_VCF_GZ: u32 = 3;
pub const FT_BCF: u32 = 4;
pub const FT_BCF_GZ: u32 = 5;
pub const FT_STDIN: u32 = 8;
pub const SAM_FORMAT_VERSION: &'static [u8; 4usize] = b"1.6\0";
pub const BAM_CMATCH: u32 = 0;
pub const BAM_CINS: u32 = 1;
pub const BAM_CDEL: u32 = 2;
pub const BAM_CREF_SKIP: u32 = 3;
pub const BAM_CSOFT_CLIP: u32 = 4;
pub const BAM_CHARD_CLIP: u32 = 5;
pub const BAM_CPAD: u32 = 6;
pub const BAM_CEQUAL: u32 = 7;
pub const BAM_CDIFF: u32 = 8;
pub const BAM_CBACK: u32 = 9;
pub const BAM_CIGAR_STR: &'static [u8; 11usize] = b"MIDNSHP=XB\0";
pub const BAM_CIGAR_SHIFT: u32 = 4;
pub const BAM_CIGAR_MASK: u32 = 15;
pub const BAM_CIGAR_TYPE: u32 = 246183;
pub const BAM_FPAIRED: u32 = 1;
pub const BAM_FPROPER_PAIR: u32 = 2;
pub const BAM_FUNMAP: u32 = 4;
pub const BAM_FMUNMAP: u32 = 8;
pub const BAM_FREVERSE: u32 = 16;
pub const BAM_FMREVERSE: u32 = 32;
pub const BAM_FREAD1: u32 = 64;
pub const BAM_FREAD2: u32 = 128;
pub const BAM_FSECONDARY: u32 = 256;
pub const BAM_FQCFAIL: u32 = 512;
pub const BAM_FDUP: u32 = 1024;
pub const BAM_FSUPPLEMENTARY: u32 = 2048;
pub const BAM_USER_OWNS_STRUCT: u32 = 1;
pub const BAM_USER_OWNS_DATA: u32 = 2;
pub const USE_SYSTEM_HTSLIB: u32 = 1;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __socklen_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type int_least8_t = __int_least8_t;
pub type int_least16_t = __int_least16_t;
pub type int_least32_t = __int_least32_t;
pub type int_least64_t = __int_least64_t;
pub type uint_least8_t = __uint_least8_t;
pub type uint_least16_t = __uint_least16_t;
pub type uint_least32_t = __uint_least32_t;
pub type uint_least64_t = __uint_least64_t;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = __intmax_t;
pub type uintmax_t = __uintmax_t;
pub type size_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[repr(align(16))]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
    pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
    pub __bindgen_padding_0: u64,
    pub __clang_max_align_nonce2: u128,
}
pub type __gwchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
extern "C" {
    pub fn imaxabs(__n: intmax_t) -> intmax_t;
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const __gwchar_t,
        __endptr: *mut *mut __gwchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub type va_list = __builtin_va_list;
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __mbstate_t {
    pub __count: ::std::os::raw::c_int,
    pub __value: __mbstate_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t__bindgen_ty_1 {
    pub __wch: ::std::os::raw::c_uint,
    pub __wchb: [::std::os::raw::c_char; 4usize],
    _bindgen_union_align: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos_t {
    pub __pos: __off_t,
    pub __state: __mbstate_t,
}
pub type __fpos_t = _G_fpos_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _G_fpos64_t {
    pub __pos: __off64_t,
    pub __state: __mbstate_t,
}
pub type __fpos64_t = _G_fpos64_t;
pub type __FILE = _IO_FILE;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: size_t,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
pub type off_t = __off_t;
pub type ssize_t = __ssize_t;
pub type fpos_t = __fpos_t;
extern "C" {
    pub static mut stdin: *mut FILE;
}
extern "C" {
    pub static mut stdout: *mut FILE;
}
extern "C" {
    pub static mut stderr: *mut FILE;
}
extern "C" {
    pub fn remove(__filename: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rename(
        __old: *const ::std::os::raw::c_char,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn renameat(
        __oldfd: ::std::os::raw::c_int,
        __old: *const ::std::os::raw::c_char,
        __newfd: ::std::os::raw::c_int,
        __new: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn tmpfile() -> *mut FILE;
}
extern "C" {
    pub fn tmpnam(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tmpnam_r(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn tempnam(
        __dir: *const ::std::os::raw::c_char,
        __pfx: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn fclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fflush_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn freopen(
        __filename: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
        __stream: *mut FILE,
    ) -> *mut FILE;
}
extern "C" {
    pub fn fdopen(__fd: ::std::os::raw::c_int, __modes: *const ::std::os::raw::c_char)
        -> *mut FILE;
}
extern "C" {
    pub fn fmemopen(
        __s: *mut ::std::os::raw::c_void,
        __len: size_t,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn open_memstream(
        __bufloc: *mut *mut ::std::os::raw::c_char,
        __sizeloc: *mut size_t,
    ) -> *mut FILE;
}
extern "C" {
    pub fn setbuf(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn setvbuf(
        __stream: *mut FILE,
        __buf: *mut ::std::os::raw::c_char,
        __modes: ::std::os::raw::c_int,
        __n: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setbuffer(__stream: *mut FILE, __buf: *mut ::std::os::raw::c_char, __size: size_t);
}
extern "C" {
    pub fn setlinebuf(__stream: *mut FILE);
}
extern "C" {
    pub fn fprintf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn printf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfprintf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vprintf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsprintf(
        __s: *mut ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn snprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsnprintf(
        __s: *mut ::std::os::raw::c_char,
        __maxlen: ::std::os::raw::c_ulong,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vdprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dprintf(
        __fd: ::std::os::raw::c_int,
        __fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fscanf(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn scanf(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_fscanf"]
    pub fn fscanf1(
        __stream: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_scanf"]
    pub fn scanf1(__format: *const ::std::os::raw::c_char, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_sscanf"]
    pub fn sscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vfscanf(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vscanf(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn vsscanf(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vfscanf"]
    pub fn vfscanf1(
        __s: *mut FILE,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vscanf"]
    pub fn vscanf1(
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}__isoc99_vsscanf"]
    pub fn vsscanf1(
        __s: *const ::std::os::raw::c_char,
        __format: *const ::std::os::raw::c_char,
        __arg: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getchar_unlocked() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgetc_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fputc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putc_unlocked(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putchar_unlocked(__c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getw(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putw(__w: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fgets(
        __s: *mut ::std::os::raw::c_char,
        __n: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn __getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getdelim(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __delimiter: ::std::os::raw::c_int,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn getline(
        __lineptr: *mut *mut ::std::os::raw::c_char,
        __n: *mut size_t,
        __stream: *mut FILE,
    ) -> __ssize_t;
}
extern "C" {
    pub fn fputs(__s: *const ::std::os::raw::c_char, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn puts(__s: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ungetc(__c: ::std::os::raw::c_int, __stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fread(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __stream: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fwrite(
        __ptr: *const ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
        __n: ::std::os::raw::c_ulong,
        __s: *mut FILE,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn fread_unlocked(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fwrite_unlocked(
        __ptr: *const ::std::os::raw::c_void,
        __size: size_t,
        __n: size_t,
        __stream: *mut FILE,
    ) -> size_t;
}
extern "C" {
    pub fn fseek(
        __stream: *mut FILE,
        __off: ::std::os::raw::c_long,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftell(__stream: *mut FILE) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rewind(__stream: *mut FILE);
}
extern "C" {
    pub fn fseeko(
        __stream: *mut FILE,
        __off: __off_t,
        __whence: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ftello(__stream: *mut FILE) -> __off_t;
}
extern "C" {
    pub fn fgetpos(__stream: *mut FILE, __pos: *mut fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fsetpos(__stream: *mut FILE, __pos: *const fpos_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr(__stream: *mut FILE);
}
extern "C" {
    pub fn feof(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn clearerr_unlocked(__stream: *mut FILE);
}
extern "C" {
    pub fn feof_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ferror_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn perror(__s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub static mut sys_nerr: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut sys_errlist: [*const ::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub fn fileno(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn fileno_unlocked(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn popen(
        __command: *const ::std::os::raw::c_char,
        __modes: *const ::std::os::raw::c_char,
    ) -> *mut FILE;
}
extern "C" {
    pub fn pclose(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ctermid(__s: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn flockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn ftrylockfile(__stream: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn funlockfile(__stream: *mut FILE);
}
extern "C" {
    pub fn __uflow(arg1: *mut FILE) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __overflow(arg1: *mut FILE, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
pub const htsLogLevel_HTS_LOG_OFF: htsLogLevel = 0;
pub const htsLogLevel_HTS_LOG_ERROR: htsLogLevel = 1;
pub const htsLogLevel_HTS_LOG_WARNING: htsLogLevel = 3;
pub const htsLogLevel_HTS_LOG_INFO: htsLogLevel = 4;
pub const htsLogLevel_HTS_LOG_DEBUG: htsLogLevel = 5;
pub const htsLogLevel_HTS_LOG_TRACE: htsLogLevel = 6;
pub type htsLogLevel = ::std::os::raw::c_uint;
extern "C" {
    pub fn hts_set_log_level(level: htsLogLevel);
}
extern "C" {
    pub fn hts_get_log_level() -> htsLogLevel;
}
extern "C" {
    pub static mut hts_verbose: ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_log(
        severity: htsLogLevel,
        context: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct BGZF {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cram_fd {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hFILE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_tpool {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kstring_t {
    pub l: size_t,
    pub m: size_t,
    pub s: *mut ::std::os::raw::c_char,
}
extern "C" {
    pub fn hts_resize_array_(
        arg1: size_t,
        arg2: size_t,
        arg3: size_t,
        arg4: *mut ::std::os::raw::c_void,
        arg5: *mut *mut ::std::os::raw::c_void,
        arg6: ::std::os::raw::c_int,
        arg7: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_free(ptr: *mut ::std::os::raw::c_void);
}
pub const htsFormatCategory_unknown_category: htsFormatCategory = 0;
pub const htsFormatCategory_sequence_data: htsFormatCategory = 1;
pub const htsFormatCategory_variant_data: htsFormatCategory = 2;
pub const htsFormatCategory_index_file: htsFormatCategory = 3;
pub const htsFormatCategory_region_list: htsFormatCategory = 4;
pub const htsFormatCategory_category_maximum: htsFormatCategory = 32767;
pub type htsFormatCategory = ::std::os::raw::c_uint;
pub const htsExactFormat_unknown_format: htsExactFormat = 0;
pub const htsExactFormat_binary_format: htsExactFormat = 1;
pub const htsExactFormat_text_format: htsExactFormat = 2;
pub const htsExactFormat_sam: htsExactFormat = 3;
pub const htsExactFormat_bam: htsExactFormat = 4;
pub const htsExactFormat_bai: htsExactFormat = 5;
pub const htsExactFormat_cram: htsExactFormat = 6;
pub const htsExactFormat_crai: htsExactFormat = 7;
pub const htsExactFormat_vcf: htsExactFormat = 8;
pub const htsExactFormat_bcf: htsExactFormat = 9;
pub const htsExactFormat_csi: htsExactFormat = 10;
pub const htsExactFormat_gzi: htsExactFormat = 11;
pub const htsExactFormat_tbi: htsExactFormat = 12;
pub const htsExactFormat_bed: htsExactFormat = 13;
pub const htsExactFormat_htsget: htsExactFormat = 14;
pub const htsExactFormat_json: htsExactFormat = 14;
pub const htsExactFormat_empty_format: htsExactFormat = 15;
pub const htsExactFormat_fasta_format: htsExactFormat = 16;
pub const htsExactFormat_fastq_format: htsExactFormat = 17;
pub const htsExactFormat_fai_format: htsExactFormat = 18;
pub const htsExactFormat_fqi_format: htsExactFormat = 19;
pub const htsExactFormat_format_maximum: htsExactFormat = 32767;
pub type htsExactFormat = ::std::os::raw::c_uint;
pub const htsCompression_no_compression: htsCompression = 0;
pub const htsCompression_gzip: htsCompression = 1;
pub const htsCompression_bgzf: htsCompression = 2;
pub const htsCompression_custom: htsCompression = 3;
pub const htsCompression_bzip2_compression: htsCompression = 4;
pub const htsCompression_compression_maximum: htsCompression = 32767;
pub type htsCompression = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat {
    pub category: htsFormatCategory,
    pub format: htsExactFormat,
    pub version: htsFormat__bindgen_ty_1,
    pub compression: htsCompression,
    pub compression_level: ::std::os::raw::c_short,
    pub specific: *mut ::std::os::raw::c_void,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsFormat__bindgen_ty_1 {
    pub major: ::std::os::raw::c_short,
    pub minor: ::std::os::raw::c_short,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __hts_idx_t {
    _unused: [u8; 0],
}
pub type hts_idx_t = __hts_idx_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct htsFile {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub lineno: i64,
    pub line: kstring_t,
    pub fn_: *mut ::std::os::raw::c_char,
    pub fn_aux: *mut ::std::os::raw::c_char,
    pub fp: htsFile__bindgen_ty_1,
    pub state: *mut ::std::os::raw::c_void,
    pub format: htsFormat,
    pub idx: *mut hts_idx_t,
    pub fnidx: *const ::std::os::raw::c_char,
    pub bam_header: *mut sam_hdr_t,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union htsFile__bindgen_ty_1 {
    pub bgzf: *mut BGZF,
    pub cram: *mut cram_fd,
    pub hfile: *mut hFILE,
    _bindgen_union_align: u64,
}
impl htsFile {
    #[inline]
    pub fn is_bin(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bin(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_write(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_write(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_be(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_be(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_bgzf(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_bgzf(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_bin: u32,
        is_write: u32,
        is_be: u32,
        is_cram: u32,
        is_bgzf: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_bin: u32 = unsafe { ::std::mem::transmute(is_bin) };
            is_bin as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_write: u32 = unsafe { ::std::mem::transmute(is_write) };
            is_write as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_be: u32 = unsafe { ::std::mem::transmute(is_be) };
            is_be as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let is_bgzf: u32 = unsafe { ::std::mem::transmute(is_bgzf) };
            is_bgzf as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct htsThreadPool {
    pub pool: *mut hts_tpool,
    pub qsize: ::std::os::raw::c_int,
}
pub const sam_fields_SAM_QNAME: sam_fields = 1;
pub const sam_fields_SAM_FLAG: sam_fields = 2;
pub const sam_fields_SAM_RNAME: sam_fields = 4;
pub const sam_fields_SAM_POS: sam_fields = 8;
pub const sam_fields_SAM_MAPQ: sam_fields = 16;
pub const sam_fields_SAM_CIGAR: sam_fields = 32;
pub const sam_fields_SAM_RNEXT: sam_fields = 64;
pub const sam_fields_SAM_PNEXT: sam_fields = 128;
pub const sam_fields_SAM_TLEN: sam_fields = 256;
pub const sam_fields_SAM_SEQ: sam_fields = 512;
pub const sam_fields_SAM_QUAL: sam_fields = 1024;
pub const sam_fields_SAM_AUX: sam_fields = 2048;
pub const sam_fields_SAM_RGAUX: sam_fields = 4096;
pub type sam_fields = ::std::os::raw::c_uint;
pub const hts_fmt_option_CRAM_OPT_DECODE_MD: hts_fmt_option = 0;
pub const hts_fmt_option_CRAM_OPT_PREFIX: hts_fmt_option = 1;
pub const hts_fmt_option_CRAM_OPT_VERBOSITY: hts_fmt_option = 2;
pub const hts_fmt_option_CRAM_OPT_SEQS_PER_SLICE: hts_fmt_option = 3;
pub const hts_fmt_option_CRAM_OPT_SLICES_PER_CONTAINER: hts_fmt_option = 4;
pub const hts_fmt_option_CRAM_OPT_RANGE: hts_fmt_option = 5;
pub const hts_fmt_option_CRAM_OPT_VERSION: hts_fmt_option = 6;
pub const hts_fmt_option_CRAM_OPT_EMBED_REF: hts_fmt_option = 7;
pub const hts_fmt_option_CRAM_OPT_IGNORE_MD5: hts_fmt_option = 8;
pub const hts_fmt_option_CRAM_OPT_REFERENCE: hts_fmt_option = 9;
pub const hts_fmt_option_CRAM_OPT_MULTI_SEQ_PER_SLICE: hts_fmt_option = 10;
pub const hts_fmt_option_CRAM_OPT_NO_REF: hts_fmt_option = 11;
pub const hts_fmt_option_CRAM_OPT_USE_BZIP2: hts_fmt_option = 12;
pub const hts_fmt_option_CRAM_OPT_SHARED_REF: hts_fmt_option = 13;
pub const hts_fmt_option_CRAM_OPT_NTHREADS: hts_fmt_option = 14;
pub const hts_fmt_option_CRAM_OPT_THREAD_POOL: hts_fmt_option = 15;
pub const hts_fmt_option_CRAM_OPT_USE_LZMA: hts_fmt_option = 16;
pub const hts_fmt_option_CRAM_OPT_USE_RANS: hts_fmt_option = 17;
pub const hts_fmt_option_CRAM_OPT_REQUIRED_FIELDS: hts_fmt_option = 18;
pub const hts_fmt_option_CRAM_OPT_LOSSY_NAMES: hts_fmt_option = 19;
pub const hts_fmt_option_CRAM_OPT_BASES_PER_SLICE: hts_fmt_option = 20;
pub const hts_fmt_option_CRAM_OPT_STORE_MD: hts_fmt_option = 21;
pub const hts_fmt_option_CRAM_OPT_STORE_NM: hts_fmt_option = 22;
pub const hts_fmt_option_HTS_OPT_COMPRESSION_LEVEL: hts_fmt_option = 100;
pub const hts_fmt_option_HTS_OPT_NTHREADS: hts_fmt_option = 101;
pub const hts_fmt_option_HTS_OPT_THREAD_POOL: hts_fmt_option = 102;
pub const hts_fmt_option_HTS_OPT_CACHE_SIZE: hts_fmt_option = 103;
pub const hts_fmt_option_HTS_OPT_BLOCK_SIZE: hts_fmt_option = 104;
pub type hts_fmt_option = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hts_opt {
    pub arg: *mut ::std::os::raw::c_char,
    pub opt: hts_fmt_option,
    pub val: hts_opt__bindgen_ty_1,
    pub next: *mut hts_opt,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union hts_opt__bindgen_ty_1 {
    pub i: ::std::os::raw::c_int,
    pub s: *mut ::std::os::raw::c_char,
    _bindgen_union_align: u64,
}
extern "C" {
    pub fn hts_opt_add(
        opts: *mut *mut hts_opt,
        c_arg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_apply(fp: *mut htsFile, opts: *mut hts_opt) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_opt_free(opts: *mut hts_opt);
}
extern "C" {
    pub fn hts_parse_format(
        opt: *mut htsFormat,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_parse_opt_list(
        opt: *mut htsFormat,
        str_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub static seq_nt16_table: [::std::os::raw::c_uchar; 256usize];
}
extern "C" {
    pub static mut seq_nt16_str: [::std::os::raw::c_char; 0usize];
}
extern "C" {
    pub static mut seq_nt16_int: [::std::os::raw::c_int; 0usize];
}
extern "C" {
    pub fn hts_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_detect_format(fp: *mut hFILE, fmt: *mut htsFormat) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_format_description(format: *const htsFormat) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_open(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_open_format(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        fmt: *const htsFormat,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_hopen(
        fp: *mut hFILE,
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
    ) -> *mut htsFile;
}
extern "C" {
    pub fn hts_close(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_get_format(fp: *mut htsFile) -> *const htsFormat;
}
extern "C" {
    pub fn hts_format_file_extension(format: *const htsFormat) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_opt(fp: *mut htsFile, opt: hts_fmt_option, ...) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_getline(
        fp: *mut htsFile,
        delimiter: ::std::os::raw::c_int,
        str_: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_readlines(
        fn_: *const ::std::os::raw::c_char,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_readlist(
        fn_: *const ::std::os::raw::c_char,
        is_file: ::std::os::raw::c_int,
        _n: *mut ::std::os::raw::c_int,
    ) -> *mut *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_set_threads(fp: *mut htsFile, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_thread_pool(fp: *mut htsFile, p: *mut htsThreadPool) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_set_cache_size(fp: *mut htsFile, n: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_set_fai_filename(
        fp: *mut htsFile,
        fn_aux: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_check_EOF(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
pub type hts_pos_t = i64;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair_pos_t {
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
}
pub type hts_pair32_t = hts_pair_pos_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_t {
    pub u: u64,
    pub v: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_pair64_max_t {
    pub u: u64,
    pub v: u64,
    pub max: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_reglist_t {
    pub reg: *const ::std::os::raw::c_char,
    pub intervals: *mut hts_pair_pos_t,
    pub tid: ::std::os::raw::c_int,
    pub count: u32,
    pub min_beg: hts_pos_t,
    pub max_end: hts_pos_t,
}
pub type hts_readrec_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut BGZF,
        data: *mut ::std::os::raw::c_void,
        r: *mut ::std::os::raw::c_void,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_seek_func = ::std::option::Option<
    unsafe extern "C" fn(
        fp: *mut ::std::os::raw::c_void,
        offset: i64,
        where_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_tell_func =
    ::std::option::Option<unsafe extern "C" fn(fp: *mut ::std::os::raw::c_void) -> i64>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t {
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub tid: ::std::os::raw::c_int,
    pub n_off: ::std::os::raw::c_int,
    pub i: ::std::os::raw::c_int,
    pub n_reg: ::std::os::raw::c_int,
    pub beg: hts_pos_t,
    pub end: hts_pos_t,
    pub reg_list: *mut hts_reglist_t,
    pub curr_tid: ::std::os::raw::c_int,
    pub curr_reg: ::std::os::raw::c_int,
    pub curr_intv: ::std::os::raw::c_int,
    pub curr_beg: hts_pos_t,
    pub curr_end: hts_pos_t,
    pub curr_off: u64,
    pub nocoor_off: u64,
    pub off: *mut hts_pair64_max_t,
    pub readrec: hts_readrec_func,
    pub seek: hts_seek_func,
    pub tell: hts_tell_func,
    pub bins: hts_itr_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_itr_t__bindgen_ty_1 {
    pub n: ::std::os::raw::c_int,
    pub m: ::std::os::raw::c_int,
    pub a: *mut ::std::os::raw::c_int,
}
impl hts_itr_t {
    #[inline]
    pub fn read_rest(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_read_rest(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn finished(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_finished(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_cram(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_cram(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nocoor(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nocoor(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn multi(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_multi(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn dummy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_dummy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        read_rest: u32,
        finished: u32,
        is_cram: u32,
        nocoor: u32,
        multi: u32,
        dummy: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let read_rest: u32 = unsafe { ::std::mem::transmute(read_rest) };
            read_rest as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let finished: u32 = unsafe { ::std::mem::transmute(finished) };
            finished as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_cram: u32 = unsafe { ::std::mem::transmute(is_cram) };
            is_cram as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let nocoor: u32 = unsafe { ::std::mem::transmute(nocoor) };
            nocoor as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let multi: u32 = unsafe { ::std::mem::transmute(multi) };
            multi as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let dummy: u32 = unsafe { ::std::mem::transmute(dummy) };
            dummy as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct aux_key_t {
    pub key: ::std::os::raw::c_int,
    pub min_off: u64,
    pub max_off: u64,
}
pub type hts_itr_multi_t = hts_itr_t;
extern "C" {
    pub fn hts_idx_init(
        n: ::std::os::raw::c_int,
        fmt: ::std::os::raw::c_int,
        offset0: u64,
        min_shift: ::std::os::raw::c_int,
        n_lvls: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_destroy(idx: *mut hts_idx_t);
}
extern "C" {
    pub fn hts_idx_push(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        offset: u64,
        is_mapped: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_finish(idx: *mut hts_idx_t, final_offset: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_fmt(idx: *mut hts_idx_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_tbi_name(
        idx: *mut hts_idx_t,
        tid: ::std::os::raw::c_int,
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_save_as(
        idx: *const hts_idx_t,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_load(
        fn_: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_load3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        fmt: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn hts_idx_get_meta(idx: *mut hts_idx_t, l_meta: *mut u32) -> *mut u8;
}
extern "C" {
    pub fn hts_idx_set_meta(
        idx: *mut hts_idx_t,
        l_meta: u32,
        meta: *mut u8,
        is_copy: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_stat(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        mapped: *mut u64,
        unmapped: *mut u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_get_n_no_coor(idx: *const hts_idx_t) -> u64;
}
extern "C" {
    pub fn hts_parse_decimal(
        str_: *const ::std::os::raw::c_char,
        strend: *mut *mut ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
pub type hts_name2id_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type hts_id2name_f = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn hts_parse_reg64(
        str_: *const ::std::os::raw::c_char,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_reg(
        str_: *const ::std::os::raw::c_char,
        beg: *mut ::std::os::raw::c_int,
        end: *mut ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_parse_region(
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn hts_itr_query(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_destroy(iter: *mut hts_itr_t);
}
pub type hts_itr_query_func = ::std::option::Option<
    unsafe extern "C" fn(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t,
>;
extern "C" {
    pub fn hts_itr_querys(
        idx: *const hts_idx_t,
        reg: *const ::std::os::raw::c_char,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_query: hts_itr_query_func,
        readrec: hts_readrec_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_next(
        fp: *mut BGZF,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_idx_seqnames(
        idx: *const hts_idx_t,
        n: *mut ::std::os::raw::c_int,
        getid: hts_id2name_f,
        hdr: *mut ::std::os::raw::c_void,
    ) -> *mut *const ::std::os::raw::c_char;
}
pub type hts_itr_multi_query_func = ::std::option::Option<
    unsafe extern "C" fn(idx: *const hts_idx_t, itr: *mut hts_itr_t) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn hts_itr_multi_bam(idx: *const hts_idx_t, iter: *mut hts_itr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_multi_cram(idx: *const hts_idx_t, iter: *mut hts_itr_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_itr_regions(
        idx: *const hts_idx_t,
        reglist: *mut hts_reglist_t,
        count: ::std::os::raw::c_int,
        getid: hts_name2id_f,
        hdr: *mut ::std::os::raw::c_void,
        itr_specific: hts_itr_multi_query_func,
        readrec: hts_readrec_func,
        seek: hts_seek_func,
        tell: hts_tell_func,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn hts_itr_multi_next(
        fd: *mut htsFile,
        iter: *mut hts_itr_t,
        r: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn hts_reglist_create(
        argv: *mut *mut ::std::os::raw::c_char,
        argc: ::std::os::raw::c_int,
        r_count: *mut ::std::os::raw::c_int,
        hdr: *mut ::std::os::raw::c_void,
        getid: hts_name2id_f,
    ) -> *mut hts_reglist_t;
}
extern "C" {
    pub fn hts_reglist_free(reglist: *mut hts_reglist_t, count: ::std::os::raw::c_int);
}
extern "C" {
    pub fn hts_file_type(fname: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct errmod_t {
    _unused: [u8; 0],
}
extern "C" {
    pub fn errmod_init(depcorr: f64) -> *mut errmod_t;
}
extern "C" {
    pub fn errmod_destroy(em: *mut errmod_t);
}
extern "C" {
    pub fn errmod_cal(
        em: *const errmod_t,
        n: ::std::os::raw::c_int,
        m: ::std::os::raw::c_int,
        bases: *mut u16,
        q: *mut f32,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct probaln_par_t {
    pub d: f32,
    pub e: f32,
    pub bw: ::std::os::raw::c_int,
}
extern "C" {
    pub fn probaln_glocal(
        ref_: *const u8,
        l_ref: ::std::os::raw::c_int,
        query: *const u8,
        l_query: ::std::os::raw::c_int,
        iqual: *const u8,
        c: *const probaln_par_t,
        state: *mut ::std::os::raw::c_int,
        q: *mut u8,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hts_md5_context {
    _unused: [u8; 0],
}
extern "C" {
    pub fn hts_md5_init() -> *mut hts_md5_context;
}
extern "C" {
    pub fn hts_md5_update(
        ctx: *mut hts_md5_context,
        data: *const ::std::os::raw::c_void,
        size: ::std::os::raw::c_ulong,
    );
}
extern "C" {
    pub fn hts_md5_final(digest: *mut ::std::os::raw::c_uchar, ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_reset(ctx: *mut hts_md5_context);
}
extern "C" {
    pub fn hts_md5_hex(hex: *mut ::std::os::raw::c_char, digest: *const ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn hts_md5_destroy(ctx: *mut hts_md5_context);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hrecs_t {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sam_hdr_t {
    pub n_targets: i32,
    pub ignore_sam_err: i32,
    pub l_text: size_t,
    pub target_len: *mut u32,
    pub cigar_tab: *const i8,
    pub target_name: *mut *mut ::std::os::raw::c_char,
    pub text: *mut ::std::os::raw::c_char,
    pub sdict: *mut ::std::os::raw::c_void,
    pub hrecs: *mut sam_hrecs_t,
    pub ref_count: u32,
}
pub type bam_hdr_t = sam_hdr_t;
extern "C" {
    pub static bam_cigar_table: [i8; 256usize];
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_core_t {
    pub pos: hts_pos_t,
    pub tid: i32,
    pub bin: u16,
    pub qual: u8,
    pub l_extranul: u8,
    pub flag: u16,
    pub l_qname: u16,
    pub n_cigar: u32,
    pub l_qseq: i32,
    pub mtid: i32,
    pub mpos: hts_pos_t,
    pub isize_: hts_pos_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bam1_t {
    pub core: bam1_core_t,
    pub id: u64,
    pub data: *mut u8,
    pub l_data: ::std::os::raw::c_int,
    pub m_data: u32,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u8>,
    pub __bindgen_padding_0: u32,
}
impl bam1_t {
    #[inline]
    pub fn mempolicy(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u32) }
    }
    #[inline]
    pub fn set_mempolicy(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(mempolicy: u32) -> __BindgenBitfieldUnit<[u8; 4usize], u8> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u8> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let mempolicy: u32 = unsafe { ::std::mem::transmute(mempolicy) };
            mempolicy as u64
        });
        __bindgen_bitfield_unit
    }
}
extern "C" {
    pub fn sam_hdr_init() -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_read(fp: *mut BGZF) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn bam_hdr_write(fp: *mut BGZF, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_destroy(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn sam_hdr_dup(h0: *const sam_hdr_t) -> *mut sam_hdr_t;
}
pub type samFile = htsFile;
extern "C" {
    pub fn sam_hdr_parse(l_text: size_t, text: *const ::std::os::raw::c_char) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_read(fp: *mut samFile) -> *mut sam_hdr_t;
}
extern "C" {
    pub fn sam_hdr_write(fp: *mut samFile, h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_length(h: *mut sam_hdr_t) -> size_t;
}
extern "C" {
    pub fn sam_hdr_str(h: *mut sam_hdr_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_nref(h: *const sam_hdr_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_lines(
        h: *mut sam_hdr_t,
        lines: *const ::std::os::raw::c_char,
        len: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_add_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_val: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_line_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        position: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_update_line(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_except(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        id: *const ::std::os::raw::c_char,
        rh: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_count_lines(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_index(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_line_name(
        bh: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_find_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_find_tag_pos(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        pos: ::std::os::raw::c_int,
        key: *const ::std::os::raw::c_char,
        ks: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_remove_tag_id(
        h: *mut sam_hdr_t,
        type_: *const ::std::os::raw::c_char,
        ID_key: *const ::std::os::raw::c_char,
        ID_value: *const ::std::os::raw::c_char,
        key: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_name2tid(
        h: *mut sam_hdr_t,
        ref_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_hdr_tid2name(
        h: *const sam_hdr_t,
        tid: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_tid2len(h: *const sam_hdr_t, tid: ::std::os::raw::c_int) -> hts_pos_t;
}
extern "C" {
    pub fn sam_hdr_pg_id(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_add_pg(
        h: *mut sam_hdr_t,
        name: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn stringify_argv(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_incr_ref(h: *mut sam_hdr_t);
}
extern "C" {
    pub fn bam_init1() -> *mut bam1_t;
}
extern "C" {
    pub fn bam_destroy1(b: *mut bam1_t);
}
extern "C" {
    pub fn bam_read1(fp: *mut BGZF, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_write1(fp: *mut BGZF, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_copy1(bdst: *mut bam1_t, bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_dup1(bsrc: *const bam1_t) -> *mut bam1_t;
}
extern "C" {
    pub fn bam_cigar2qlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_cigar2rlen(n_cigar: ::std::os::raw::c_int, cigar: *const u32) -> hts_pos_t;
}
extern "C" {
    pub fn bam_endpos(b: *const bam1_t) -> hts_pos_t;
}
extern "C" {
    pub fn bam_str2flag(str_: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_flag2str(flag: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_set_qname(
        b: *mut bam1_t,
        qname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_init(
        fp: *mut htsFile,
        h: *mut sam_hdr_t,
        min_shift: ::std::os::raw::c_int,
        fnidx: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_idx_save(fp: *mut htsFile) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_load(fp: *mut htsFile, fn_: *const ::std::os::raw::c_char) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load2(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_load3(
        fp: *mut htsFile,
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut hts_idx_t;
}
extern "C" {
    pub fn sam_index_build(
        fn_: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build2(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_index_build3(
        fn_: *const ::std::os::raw::c_char,
        fnidx: *const ::std::os::raw::c_char,
        min_shift: ::std::os::raw::c_int,
        nthreads: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_itr_queryi(
        idx: *const hts_idx_t,
        tid: ::std::os::raw::c_int,
        beg: hts_pos_t,
        end: hts_pos_t,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_querys(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        region: *const ::std::os::raw::c_char,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regions(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        reglist: *mut hts_reglist_t,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_itr_regarray(
        idx: *const hts_idx_t,
        hdr: *mut sam_hdr_t,
        regarray: *mut *mut ::std::os::raw::c_char,
        regcount: ::std::os::raw::c_uint,
    ) -> *mut hts_itr_t;
}
extern "C" {
    pub fn sam_parse_region(
        h: *mut sam_hdr_t,
        s: *const ::std::os::raw::c_char,
        tid: *mut ::std::os::raw::c_int,
        beg: *mut hts_pos_t,
        end: *mut hts_pos_t,
        flags: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_open_mode(
        mode: *mut ::std::os::raw::c_char,
        fn_: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_open_mode_opts(
        fn_: *const ::std::os::raw::c_char,
        mode: *const ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn sam_hdr_change_HD(
        h: *mut sam_hdr_t,
        key: *const ::std::os::raw::c_char,
        val: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_parse1(
        s: *mut kstring_t,
        h: *mut sam_hdr_t,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_format1(
        h: *const sam_hdr_t,
        b: *const bam1_t,
        str_: *mut kstring_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_read1(fp: *mut samFile, h: *mut sam_hdr_t, b: *mut bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_write1(
        fp: *mut samFile,
        h: *const sam_hdr_t,
        b: *const bam1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_get(b: *const bam1_t, tag: *const ::std::os::raw::c_char) -> *mut u8;
}
extern "C" {
    pub fn bam_aux2i(s: *const u8) -> i64;
}
extern "C" {
    pub fn bam_aux2f(s: *const u8) -> f64;
}
extern "C" {
    pub fn bam_aux2A(s: *const u8) -> ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_aux2Z(s: *const u8) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn bam_auxB_len(s: *const u8) -> u32;
}
extern "C" {
    pub fn bam_auxB2i(s: *const u8, idx: u32) -> i64;
}
extern "C" {
    pub fn bam_auxB2f(s: *const u8, idx: u32) -> f64;
}
extern "C" {
    pub fn bam_aux_append(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_del(b: *mut bam1_t, s: *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_str(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
        data: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_int(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: i64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_float(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        val: f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_aux_update_array(
        b: *mut bam1_t,
        tag: *const ::std::os::raw::c_char,
        type_: u8,
        items: u32,
        data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bam_pileup_cd {
    pub p: *mut ::std::os::raw::c_void,
    pub i: i64,
    pub f: f64,
    _bindgen_union_align: u64,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bam_pileup1_t {
    pub b: *mut bam1_t,
    pub qpos: i32,
    pub indel: ::std::os::raw::c_int,
    pub level: ::std::os::raw::c_int,
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize], u32>,
    pub cd: bam_pileup_cd,
    pub cigar_ind: ::std::os::raw::c_int,
}
impl bam_pileup1_t {
    #[inline]
    pub fn is_del(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_del(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_head(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_head(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_tail(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_tail(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn is_refskip(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_is_refskip(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn aux(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 27u8) as u32) }
    }
    #[inline]
    pub fn set_aux(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 27u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        is_del: u32,
        is_head: u32,
        is_tail: u32,
        is_refskip: u32,
        aux: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize], u32> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize], u32> =
            Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let is_del: u32 = unsafe { ::std::mem::transmute(is_del) };
            is_del as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let is_head: u32 = unsafe { ::std::mem::transmute(is_head) };
            is_head as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let is_tail: u32 = unsafe { ::std::mem::transmute(is_tail) };
            is_tail as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let is_refskip: u32 = unsafe { ::std::mem::transmute(is_refskip) };
            is_refskip as u64
        });
        __bindgen_bitfield_unit.set(5usize, 27u8, {
            let aux: u32 = unsafe { ::std::mem::transmute(aux) };
            aux as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type bam_plp_auto_f = ::std::option::Option<
    unsafe extern "C" fn(
        data: *mut ::std::os::raw::c_void,
        b: *mut bam1_t,
    ) -> ::std::os::raw::c_int,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __bam_plp_t {
    _unused: [u8; 0],
}
pub type bam_plp_t = *mut __bam_plp_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __bam_mplp_t {
    _unused: [u8; 0],
}
pub type bam_mplp_t = *mut __bam_mplp_t;
extern "C" {
    pub fn bam_plp_init(func: bam_plp_auto_f, data: *mut ::std::os::raw::c_void) -> bam_plp_t;
}
extern "C" {
    pub fn bam_plp_destroy(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_push(iter: bam_plp_t, b: *const bam1_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_plp_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_next(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp64_auto(
        iter: bam_plp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        _n_plp: *mut ::std::os::raw::c_int,
    ) -> *const bam_pileup1_t;
}
extern "C" {
    pub fn bam_plp_set_maxcnt(iter: bam_plp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_plp_reset(iter: bam_plp_t);
}
extern "C" {
    pub fn bam_plp_constructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_destructor(
        plp: bam_plp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_plp_insertion(
        p: *const bam_pileup1_t,
        ins: *mut kstring_t,
        del_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_init(
        n: ::std::os::raw::c_int,
        func: bam_plp_auto_f,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> bam_mplp_t;
}
extern "C" {
    pub fn bam_mplp_init_overlaps(iter: bam_mplp_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_destroy(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_set_maxcnt(iter: bam_mplp_t, maxcnt: ::std::os::raw::c_int);
}
extern "C" {
    pub fn bam_mplp_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut ::std::os::raw::c_int,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp64_auto(
        iter: bam_mplp_t,
        _tid: *mut ::std::os::raw::c_int,
        _pos: *mut hts_pos_t,
        n_plp: *mut ::std::os::raw::c_int,
        plp: *mut *const bam_pileup1_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bam_mplp_reset(iter: bam_mplp_t);
}
extern "C" {
    pub fn bam_mplp_constructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn bam_mplp_destructor(
        iter: bam_mplp_t,
        func: ::std::option::Option<
            unsafe extern "C" fn(
                data: *mut ::std::os::raw::c_void,
                b: *const bam1_t,
                cd: *mut bam_pileup_cd,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn sam_cap_mapq(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        thres: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sam_prob_realn(
        b: *mut bam1_t,
        ref_: *const ::std::os::raw::c_char,
        ref_len: hts_pos_t,
        flag: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
