#![doc = "Peripheral access API for ALLWINNER_D1_UNOFFICIAL microcontrollers (generated using svd2rust v0.20.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.20.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn UART0();
    fn UART1();
    fn UART2();
    fn UART3();
    fn UART4();
    fn UART5();
    fn TWI0();
    fn TWI1();
    fn TWI2();
    fn TWI3();
    fn SPI0();
    fn SPI1();
    fn PWM();
    fn IR_TX();
    fn LEDC();
    fn USB0_DEVICE();
    fn USB0_EHCI();
    fn USB0_OHCI();
    fn USB1_EHCI();
    fn USB1_OHCI();
    fn EMAC();
    fn CE_NS();
    fn HSTIMER0();
    fn HSTIMER1();
    fn GPADC();
    fn TIMER0();
    fn TIMER1();
    fn LRADC();
    fn TPADC();
    fn WATCHDOG();
    fn GPIOB_NS();
    fn GPIOC_NS();
    fn GPIOD_NS();
    fn GPIOE_NS();
    fn GPIOF_NS();
    fn IR_RX();
}
#[doc(hidden)]
pub union Vector {
    pub _handler: unsafe extern "C" fn(),
    pub _reserved: usize,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[no_mangle]
pub static __EXTERNAL_INTERRUPTS: [Vector; 168] = [
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: UART0 },
    Vector { _handler: UART1 },
    Vector { _handler: UART2 },
    Vector { _handler: UART3 },
    Vector { _handler: UART4 },
    Vector { _handler: UART5 },
    Vector { _reserved: 0 },
    Vector { _handler: TWI0 },
    Vector { _handler: TWI1 },
    Vector { _handler: TWI2 },
    Vector { _handler: TWI3 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SPI0 },
    Vector { _handler: SPI1 },
    Vector { _reserved: 0 },
    Vector { _handler: PWM },
    Vector { _handler: IR_TX },
    Vector { _handler: LEDC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: USB0_DEVICE,
    },
    Vector {
        _handler: USB0_EHCI,
    },
    Vector {
        _handler: USB0_OHCI,
    },
    Vector { _reserved: 0 },
    Vector {
        _handler: USB1_EHCI,
    },
    Vector {
        _handler: USB1_OHCI,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: EMAC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: CE_NS },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: HSTIMER0 },
    Vector { _handler: HSTIMER1 },
    Vector { _handler: GPADC },
    Vector { _reserved: 0 },
    Vector { _handler: TIMER0 },
    Vector { _handler: TIMER1 },
    Vector { _handler: LRADC },
    Vector { _handler: TPADC },
    Vector { _handler: WATCHDOG },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOB_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOC_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOD_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOE_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOF_NS },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: IR_RX },
];
#[doc(hidden)]
pub mod interrupt;
pub use self::interrupt::Interrupt;
#[doc = "Clock Controller Unit"]
pub struct CCU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CCU {}
impl CCU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ccu::RegisterBlock = 0x0200_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ccu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CCU {
    type Target = ccu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CCU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CCU").finish()
    }
}
#[doc = "Clock Controller Unit"]
pub mod ccu;
#[doc = "Core-Local Interruptor"]
pub struct CLINT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLINT {}
impl CLINT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clint::RegisterBlock = 0x1400_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clint::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLINT {
    type Target = clint::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLINT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLINT").finish()
    }
}
#[doc = "Core-Local Interruptor"]
pub mod clint;
#[doc = "Timer Module, includes timer0, timer1, watchdog and audio video synchronization"]
pub struct TIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER {}
impl TIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer::RegisterBlock = 0x0205_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER {
    type Target = timer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER").finish()
    }
}
#[doc = "Timer Module, includes timer0, timer1, watchdog and audio video synchronization"]
pub mod timer;
#[doc = "High Speed Timer"]
pub struct HSTIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HSTIMER {}
impl HSTIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hstimer::RegisterBlock = 0x0300_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hstimer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HSTIMER {
    type Target = hstimer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HSTIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HSTIMER").finish()
    }
}
#[doc = "High Speed Timer"]
pub mod hstimer;
#[doc = "Platform Level Interrupt Control"]
pub struct PLIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PLIC {}
impl PLIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const plic::RegisterBlock = 0x1000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const plic::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PLIC {
    type Target = plic::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PLIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PLIC").finish()
    }
}
#[doc = "Platform Level Interrupt Control"]
pub mod plic;
#[doc = "Two Wire Interface"]
pub struct TWI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI0 {}
impl TWI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi0::RegisterBlock = 0x0250_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI0 {
    type Target = twi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI0").finish()
    }
}
#[doc = "Two Wire Interface"]
pub mod twi0;
#[doc = "Two Wire Interface"]
pub struct TWI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI1 {}
impl TWI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi1::RegisterBlock = 0x0250_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI1 {
    type Target = twi1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI1").finish()
    }
}
#[doc = "Two Wire Interface"]
pub mod twi1;
#[doc = "Two Wire Interface"]
pub struct TWI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI2 {}
impl TWI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi2::RegisterBlock = 0x0250_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI2 {
    type Target = twi2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI2").finish()
    }
}
#[doc = "Two Wire Interface"]
pub mod twi2;
#[doc = "Two Wire Interface"]
pub struct TWI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI3 {}
impl TWI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi3::RegisterBlock = 0x0250_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI3 {
    type Target = twi3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI3").finish()
    }
}
#[doc = "Two Wire Interface"]
pub mod twi3;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart0::RegisterBlock = 0x0250_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart0;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart1::RegisterBlock = 0x0250_0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart1;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart2::RegisterBlock = 0x0250_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart2::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart2::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart2;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART3 {}
impl UART3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart3::RegisterBlock = 0x0250_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart3::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART3 {
    type Target = uart3::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART3").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart3;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART4 {}
impl UART4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart4::RegisterBlock = 0x0250_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart4::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART4 {
    type Target = uart4::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART4").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart4;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART5 {}
impl UART5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart5::RegisterBlock = 0x0250_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart5::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART5 {
    type Target = uart5::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART5").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart5;
#[doc = "Serial Peripheral Interface"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x0402_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "Serial Peripheral Interface"]
pub mod spi0;
#[doc = "Serial Peripheral Interface Display Bus Interface"]
pub struct SPI_DBI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI_DBI {}
impl SPI_DBI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi_dbi::RegisterBlock = 0x0402_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi_dbi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI_DBI {
    type Target = spi_dbi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI_DBI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI_DBI").finish()
    }
}
#[doc = "Serial Peripheral Interface Display Bus Interface"]
pub mod spi_dbi;
#[doc = "USB2.0 HOST"]
pub struct USB1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB1 {}
impl USB1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb1::RegisterBlock = 0x0420_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB1 {
    type Target = usb1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB1").finish()
    }
}
#[doc = "USB2.0 HOST"]
pub mod usb1;
#[doc = "Gerneral Purpose Input/Output"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x0200_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "Gerneral Purpose Input/Output"]
pub mod gpio;
#[doc = "General Purpose ADC"]
pub struct GPADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPADC {}
impl GPADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpadc::RegisterBlock = 0x0200_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpadc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPADC {
    type Target = gpadc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPADC").finish()
    }
}
#[doc = "General Purpose ADC"]
pub mod gpadc;
#[doc = "Touch Panel ADC"]
pub struct TPADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TPADC {}
impl TPADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tpadc::RegisterBlock = 0x0200_9c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tpadc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TPADC {
    type Target = tpadc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TPADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TPADC").finish()
    }
}
#[doc = "Touch Panel ADC"]
pub mod tpadc;
#[doc = "Low Rate ADC"]
pub struct LRADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LRADC {}
impl LRADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lradc::RegisterBlock = 0x0200_9800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lradc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LRADC {
    type Target = lradc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LRADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LRADC").finish()
    }
}
#[doc = "Low Rate ADC"]
pub mod lradc;
#[doc = "Pulse Width Modulation"]
pub struct PWM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM {}
impl PWM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm::RegisterBlock = 0x0200_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM {
    type Target = pwm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM").finish()
    }
}
#[doc = "Pulse Width Modulation"]
pub mod pwm;
#[doc = "LEDC"]
pub struct LEDC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LEDC {}
impl LEDC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ledc::RegisterBlock = 0x0200_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ledc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LEDC {
    type Target = ledc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LEDC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LEDC").finish()
    }
}
#[doc = "LEDC"]
pub mod ledc;
#[doc = "Ethernet Medium Access Controller"]
pub struct EMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EMAC {}
impl EMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const emac::RegisterBlock = 0x0450_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const emac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EMAC {
    type Target = emac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EMAC").finish()
    }
}
#[doc = "Ethernet Medium Access Controller"]
pub mod emac;
#[doc = "Counsumer Infrared Receiver"]
pub struct CIR_RX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CIR_RX {}
impl CIR_RX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cir_rx::RegisterBlock = 0x0704_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cir_rx::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CIR_RX {
    type Target = cir_rx::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CIR_RX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CIR_RX").finish()
    }
}
#[doc = "Counsumer Infrared Receiver"]
pub mod cir_rx;
#[doc = "Counsumer Infrared Transmitter"]
pub struct CIR_TX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CIR_TX {}
impl CIR_TX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cir_tx::RegisterBlock = 0x0200_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cir_tx::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CIR_TX {
    type Target = cir_tx::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CIR_TX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CIR_TX").finish()
    }
}
#[doc = "Counsumer Infrared Transmitter"]
pub mod cir_tx;
#[doc = "Crypoto Engine"]
pub struct CE_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CE_NS {}
impl CE_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ce_ns::RegisterBlock = 0x0304_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ce_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CE_NS {
    type Target = ce_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CE_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CE_NS").finish()
    }
}
#[doc = "Crypoto Engine"]
pub mod ce_ns;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "CCU"]
    pub CCU: CCU,
    #[doc = "CLINT"]
    pub CLINT: CLINT,
    #[doc = "TIMER"]
    pub TIMER: TIMER,
    #[doc = "HSTIMER"]
    pub HSTIMER: HSTIMER,
    #[doc = "PLIC"]
    pub PLIC: PLIC,
    #[doc = "TWI0"]
    pub TWI0: TWI0,
    #[doc = "TWI1"]
    pub TWI1: TWI1,
    #[doc = "TWI2"]
    pub TWI2: TWI2,
    #[doc = "TWI3"]
    pub TWI3: TWI3,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "UART3"]
    pub UART3: UART3,
    #[doc = "UART4"]
    pub UART4: UART4,
    #[doc = "UART5"]
    pub UART5: UART5,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI_DBI"]
    pub SPI_DBI: SPI_DBI,
    #[doc = "USB1"]
    pub USB1: USB1,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "GPADC"]
    pub GPADC: GPADC,
    #[doc = "TPADC"]
    pub TPADC: TPADC,
    #[doc = "LRADC"]
    pub LRADC: LRADC,
    #[doc = "PWM"]
    pub PWM: PWM,
    #[doc = "LEDC"]
    pub LEDC: LEDC,
    #[doc = "EMAC"]
    pub EMAC: EMAC,
    #[doc = "CIR_RX"]
    pub CIR_RX: CIR_RX,
    #[doc = "CIR_TX"]
    pub CIR_TX: CIR_TX,
    #[doc = "CE_NS"]
    pub CE_NS: CE_NS,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        riscv::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            CCU: CCU {
                _marker: PhantomData,
            },
            CLINT: CLINT {
                _marker: PhantomData,
            },
            TIMER: TIMER {
                _marker: PhantomData,
            },
            HSTIMER: HSTIMER {
                _marker: PhantomData,
            },
            PLIC: PLIC {
                _marker: PhantomData,
            },
            TWI0: TWI0 {
                _marker: PhantomData,
            },
            TWI1: TWI1 {
                _marker: PhantomData,
            },
            TWI2: TWI2 {
                _marker: PhantomData,
            },
            TWI3: TWI3 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            UART3: UART3 {
                _marker: PhantomData,
            },
            UART4: UART4 {
                _marker: PhantomData,
            },
            UART5: UART5 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI_DBI: SPI_DBI {
                _marker: PhantomData,
            },
            USB1: USB1 {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            GPADC: GPADC {
                _marker: PhantomData,
            },
            TPADC: TPADC {
                _marker: PhantomData,
            },
            LRADC: LRADC {
                _marker: PhantomData,
            },
            PWM: PWM {
                _marker: PhantomData,
            },
            LEDC: LEDC {
                _marker: PhantomData,
            },
            EMAC: EMAC {
                _marker: PhantomData,
            },
            CIR_RX: CIR_RX {
                _marker: PhantomData,
            },
            CIR_TX: CIR_TX {
                _marker: PhantomData,
            },
            CE_NS: CE_NS {
                _marker: PhantomData,
            },
        }
    }
}
