#![doc = "Peripheral access API for D1H microcontrollers (generated using svd2rust v0.24.0 ( ))\n\nYou can find an overview of the generated API [here].\n\nAPI features to be included in the [next]
svd2rust release can be generated by cloning the svd2rust [repository], checking out the above commit, and running `cargo doc --open`.\n\n[here]: https://docs.rs/svd2rust/0.24.0/svd2rust/#peripheral-api\n[next]: https://github.com/rust-embedded/svd2rust/blob/master/CHANGELOG.md#unreleased\n[repository]: https://github.com/rust-embedded/svd2rust"]
#![deny(const_err)]
#![deny(dead_code)]
#![deny(improper_ctypes)]
#![deny(missing_docs)]
#![deny(no_mangle_generic_items)]
#![deny(non_shorthand_field_patterns)]
#![deny(overflowing_literals)]
#![deny(path_statements)]
#![deny(patterns_in_fns_without_body)]
#![deny(private_in_public)]
#![deny(unconditional_recursion)]
#![deny(unused_allocation)]
#![deny(unused_comparisons)]
#![deny(unused_parens)]
#![deny(while_true)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]
#![no_std]
use core::marker::PhantomData;
use core::ops::Deref;
#[allow(unused_imports)]
use generic::*;
#[doc = r"Common register and bit access and modify traits"]
pub mod generic;
#[cfg(feature = "rt")]
extern "C" {
    fn UART0();
    fn UART1();
    fn UART2();
    fn UART3();
    fn UART4();
    fn UART5();
    fn TWI0();
    fn TWI1();
    fn TWI2();
    fn TWI3();
    fn SPI0();
    fn SPI1();
    fn PWM();
    fn IR_TX();
    fn LEDC();
    fn OWA();
    fn DMIC();
    fn AUDIO_CODEC();
    fn I2S_PCM0();
    fn I2S_PCM1();
    fn I2S_PCM2();
    fn USB0_DEVICE();
    fn USB0_EHCI();
    fn USB0_OHCI();
    fn USB1_EHCI();
    fn USB1_OHCI();
    fn SMHC0();
    fn SMHC1();
    fn SMHC2();
    fn EMAC();
    fn DMAC_NS();
    fn CE_NS();
    fn SPINLOCK();
    fn HSTIMER0();
    fn HSTIMER1();
    fn GPADC();
    fn THS();
    fn TIMER0();
    fn TIMER1();
    fn LRADC();
    fn TPADC();
    fn WATCHDOG();
    fn IOMMU();
    fn GPIOB_NS();
    fn GPIOC_NS();
    fn GPIOD_NS();
    fn GPIOE_NS();
    fn GPIOF_NS();
    fn CSI_DMA0();
    fn CSI_DMA1();
    fn CSI_TOP_PKT();
    fn TVD();
    fn DSP_MBOX_RV_W();
    fn RV_MBOX_RV();
    fn RV_MBOX_DSP();
    fn IR_RX();
}
#[doc(hidden)]
pub union Vector {
    pub _handler: unsafe extern "C" fn(),
    pub _reserved: usize,
}
#[cfg(feature = "rt")]
#[doc(hidden)]
#[no_mangle]
pub static __EXTERNAL_INTERRUPTS: [Vector; 168] = [
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: UART0 },
    Vector { _handler: UART1 },
    Vector { _handler: UART2 },
    Vector { _handler: UART3 },
    Vector { _handler: UART4 },
    Vector { _handler: UART5 },
    Vector { _reserved: 0 },
    Vector { _handler: TWI0 },
    Vector { _handler: TWI1 },
    Vector { _handler: TWI2 },
    Vector { _handler: TWI3 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SPI0 },
    Vector { _handler: SPI1 },
    Vector { _reserved: 0 },
    Vector { _handler: PWM },
    Vector { _handler: IR_TX },
    Vector { _handler: LEDC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: OWA },
    Vector { _handler: DMIC },
    Vector {
        _handler: AUDIO_CODEC,
    },
    Vector { _handler: I2S_PCM0 },
    Vector { _handler: I2S_PCM1 },
    Vector { _handler: I2S_PCM2 },
    Vector {
        _handler: USB0_DEVICE,
    },
    Vector {
        _handler: USB0_EHCI,
    },
    Vector {
        _handler: USB0_OHCI,
    },
    Vector { _reserved: 0 },
    Vector {
        _handler: USB1_EHCI,
    },
    Vector {
        _handler: USB1_OHCI,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: SMHC0 },
    Vector { _handler: SMHC1 },
    Vector { _handler: SMHC2 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: EMAC },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: DMAC_NS },
    Vector { _reserved: 0 },
    Vector { _handler: CE_NS },
    Vector { _reserved: 0 },
    Vector { _handler: SPINLOCK },
    Vector { _handler: HSTIMER0 },
    Vector { _handler: HSTIMER1 },
    Vector { _handler: GPADC },
    Vector { _handler: THS },
    Vector { _handler: TIMER0 },
    Vector { _handler: TIMER1 },
    Vector { _handler: LRADC },
    Vector { _handler: TPADC },
    Vector { _handler: WATCHDOG },
    Vector { _handler: IOMMU },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOB_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOC_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOD_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOE_NS },
    Vector { _reserved: 0 },
    Vector { _handler: GPIOF_NS },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: CSI_DMA0 },
    Vector { _handler: CSI_DMA1 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: CSI_TOP_PKT,
    },
    Vector { _handler: TVD },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: DSP_MBOX_RV_W,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector {
        _handler: RV_MBOX_RV,
    },
    Vector {
        _handler: RV_MBOX_DSP,
    },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _reserved: 0 },
    Vector { _handler: IR_RX },
];
#[doc(hidden)]
pub mod interrupt;
pub use self::interrupt::Interrupt;
#[doc = "Clock Controller Unit"]
pub struct CCU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CCU {}
impl CCU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ccu::RegisterBlock = 0x0200_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ccu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CCU {
    type Target = ccu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CCU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CCU").finish()
    }
}
#[doc = "Clock Controller Unit"]
pub mod ccu;
#[doc = "System Configuration"]
pub struct SYS_CFG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SYS_CFG {}
impl SYS_CFG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const sys_cfg::RegisterBlock = 0x0300_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const sys_cfg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SYS_CFG {
    type Target = sys_cfg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SYS_CFG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SYS_CFG").finish()
    }
}
#[doc = "System Configuration"]
pub mod sys_cfg;
#[doc = "RISC-V System Configuration"]
pub struct RISCV_CFG {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RISCV_CFG {}
impl RISCV_CFG {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const riscv_cfg::RegisterBlock = 0x0601_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const riscv_cfg::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RISCV_CFG {
    type Target = riscv_cfg::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RISCV_CFG {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RISCV_CFG").finish()
    }
}
#[doc = "RISC-V System Configuration"]
pub mod riscv_cfg;
#[doc = "Core-Local Interruptor"]
pub struct CLINT {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CLINT {}
impl CLINT {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const clint::RegisterBlock = 0x1400_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const clint::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CLINT {
    type Target = clint::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CLINT {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CLINT").finish()
    }
}
#[doc = "Core-Local Interruptor"]
pub mod clint;
#[doc = "Timer Module, includes timer0, timer1, watchdog and audio video synchronization"]
pub struct TIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TIMER {}
impl TIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const timer::RegisterBlock = 0x0205_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const timer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TIMER {
    type Target = timer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TIMER").finish()
    }
}
#[doc = "Timer Module, includes timer0, timer1, watchdog and audio video synchronization"]
pub mod timer;
#[doc = "High Speed Timer"]
pub struct HSTIMER {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for HSTIMER {}
impl HSTIMER {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const hstimer::RegisterBlock = 0x0300_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const hstimer::RegisterBlock {
        Self::PTR
    }
}
impl Deref for HSTIMER {
    type Target = hstimer::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for HSTIMER {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("HSTIMER").finish()
    }
}
#[doc = "High Speed Timer"]
pub mod hstimer;
#[doc = "Platform Level Interrupt Control"]
pub struct PLIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PLIC {}
impl PLIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const plic::RegisterBlock = 0x1000_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const plic::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PLIC {
    type Target = plic::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PLIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PLIC").finish()
    }
}
#[doc = "Platform Level Interrupt Control"]
pub mod plic;
#[doc = "Direct Memory Access Controller"]
pub struct DMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMAC {}
impl DMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dmac::RegisterBlock = 0x0300_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dmac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMAC {
    type Target = dmac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMAC").finish()
    }
}
#[doc = "Direct Memory Access Controller"]
pub mod dmac;
#[doc = "Thermal Sensor Controller"]
pub struct THS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for THS {}
impl THS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ths::RegisterBlock = 0x0200_9400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ths::RegisterBlock {
        Self::PTR
    }
}
impl Deref for THS {
    type Target = ths::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for THS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("THS").finish()
    }
}
#[doc = "Thermal Sensor Controller"]
pub mod ths;
#[doc = "I/O Memory Management Unit"]
pub struct IOMMU {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for IOMMU {}
impl IOMMU {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const iommu::RegisterBlock = 0x0201_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const iommu::RegisterBlock {
        Self::PTR
    }
}
impl Deref for IOMMU {
    type Target = iommu::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for IOMMU {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("IOMMU").finish()
    }
}
#[doc = "I/O Memory Management Unit"]
pub mod iommu;
#[doc = "DSP Message Box"]
pub struct DSP_MSGBOX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DSP_MSGBOX {}
impl DSP_MSGBOX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dsp_msgbox::RegisterBlock = 0x0170_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dsp_msgbox::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DSP_MSGBOX {
    type Target = dsp_msgbox::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DSP_MSGBOX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DSP_MSGBOX").finish()
    }
}
#[doc = "DSP Message Box"]
pub mod dsp_msgbox;
#[doc = "RISC-V Message Box"]
pub struct RV_MSGBOX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RV_MSGBOX {}
impl RV_MSGBOX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dsp_msgbox::RegisterBlock = 0x0601_f000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dsp_msgbox::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RV_MSGBOX {
    type Target = dsp_msgbox::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RV_MSGBOX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RV_MSGBOX").finish()
    }
}
#[doc = "RISC-V Message Box"]
pub use dsp_msgbox as rv_msgbox;
#[doc = "Spinlock"]
pub struct SPINLOCK {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPINLOCK {}
impl SPINLOCK {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spinlock::RegisterBlock = 0x0300_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spinlock::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPINLOCK {
    type Target = spinlock::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPINLOCK {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPINLOCK").finish()
    }
}
#[doc = "Spinlock"]
pub mod spinlock;
#[doc = "Real Time CLock"]
pub struct RTC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for RTC {}
impl RTC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const rtc::RegisterBlock = 0x0709_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const rtc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for RTC {
    type Target = rtc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for RTC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("RTC").finish()
    }
}
#[doc = "Real Time CLock"]
pub mod rtc;
#[doc = "Timing COntroller LCD"]
pub struct TCON_LCD0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCON_LCD0 {}
impl TCON_LCD0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcon_lcd0::RegisterBlock = 0x0546_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcon_lcd0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCON_LCD0 {
    type Target = tcon_lcd0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCON_LCD0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCON_LCD0").finish()
    }
}
#[doc = "Timing COntroller LCD"]
pub mod tcon_lcd0;
#[doc = "Timing COntroller TV"]
pub struct TCON_TV0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TCON_TV0 {}
impl TCON_TV0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tcon_tv0::RegisterBlock = 0x0547_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tcon_tv0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TCON_TV0 {
    type Target = tcon_tv0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TCON_TV0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TCON_TV0").finish()
    }
}
#[doc = "Timing COntroller TV"]
pub mod tcon_tv0;
#[doc = "TV Encoder TOP"]
pub struct TVE_TOP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TVE_TOP {}
impl TVE_TOP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tve_top::RegisterBlock = 0x0560_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tve_top::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TVE_TOP {
    type Target = tve_top::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TVE_TOP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TVE_TOP").finish()
    }
}
#[doc = "TV Encoder TOP"]
pub mod tve_top;
#[doc = "TV Encoder"]
pub struct TVE {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TVE {}
impl TVE {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tve::RegisterBlock = 0x0560_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tve::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TVE {
    type Target = tve::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TVE {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TVE").finish()
    }
}
#[doc = "TV Encoder"]
pub mod tve;
#[doc = "CMOS Sensor Interface Controller"]
pub struct CSIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CSIC {}
impl CSIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const csic::RegisterBlock = 0x0580_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const csic::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CSIC {
    type Target = csic::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CSIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CSIC").finish()
    }
}
#[doc = "CMOS Sensor Interface Controller"]
pub mod csic;
#[doc = "Television Decoder TOP"]
pub struct TVD_TOP {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TVD_TOP {}
impl TVD_TOP {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tvd_top::RegisterBlock = 0x05c0_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tvd_top::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TVD_TOP {
    type Target = tvd_top::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TVD_TOP {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TVD_TOP").finish()
    }
}
#[doc = "Television Decoder TOP"]
pub mod tvd_top;
#[doc = "Television Decoder"]
pub struct TVD0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TVD0 {}
impl TVD0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tvd0::RegisterBlock = 0x05c0_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tvd0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TVD0 {
    type Target = tvd0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TVD0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TVD0").finish()
    }
}
#[doc = "Television Decoder"]
pub mod tvd0;
#[doc = "SD/MMC Host Controller"]
pub struct SMHC0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMHC0 {}
impl SMHC0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smhc::RegisterBlock = 0x0402_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smhc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMHC0 {
    type Target = smhc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMHC0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMHC0").finish()
    }
}
#[doc = "SD/MMC Host Controller"]
pub struct SMHC1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMHC1 {}
impl SMHC1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smhc::RegisterBlock = 0x0402_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smhc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMHC1 {
    type Target = smhc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMHC1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMHC1").finish()
    }
}
#[doc = "SD/MMC Host Controller"]
pub struct SMHC2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SMHC2 {}
impl SMHC2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const smhc::RegisterBlock = 0x0402_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const smhc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SMHC2 {
    type Target = smhc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SMHC2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SMHC2").finish()
    }
}
#[doc = "SD/MMC Host Controller"]
pub mod smhc;
#[doc = "I2S/PCM"]
pub struct I2S_PCM0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S_PCM0 {}
impl I2S_PCM0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s_pcm::RegisterBlock = 0x0203_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s_pcm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S_PCM0 {
    type Target = i2s_pcm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S_PCM0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S_PCM0").finish()
    }
}
#[doc = "I2S/PCM"]
pub struct I2S_PCM1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S_PCM1 {}
impl I2S_PCM1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s_pcm::RegisterBlock = 0x0203_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s_pcm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S_PCM1 {
    type Target = i2s_pcm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S_PCM1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S_PCM1").finish()
    }
}
#[doc = "I2S/PCM"]
pub struct I2S_PCM2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for I2S_PCM2 {}
impl I2S_PCM2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const i2s_pcm::RegisterBlock = 0x0203_4000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const i2s_pcm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for I2S_PCM2 {
    type Target = i2s_pcm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for I2S_PCM2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("I2S_PCM2").finish()
    }
}
#[doc = "I2S/PCM"]
pub mod i2s_pcm;
#[doc = "DMIC"]
pub struct DMIC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for DMIC {}
impl DMIC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const dmic::RegisterBlock = 0x0203_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const dmic::RegisterBlock {
        Self::PTR
    }
}
impl Deref for DMIC {
    type Target = dmic::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for DMIC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("DMIC").finish()
    }
}
#[doc = "DMIC"]
pub mod dmic;
#[doc = "One Wire Audio"]
pub struct OWA {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for OWA {}
impl OWA {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const owa::RegisterBlock = 0x0203_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const owa::RegisterBlock {
        Self::PTR
    }
}
impl Deref for OWA {
    type Target = owa::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for OWA {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("OWA").finish()
    }
}
#[doc = "One Wire Audio"]
pub mod owa;
#[doc = "Audio Codec"]
pub struct AUDIOCODEC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for AUDIOCODEC {}
impl AUDIOCODEC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const audio_codec::RegisterBlock = 0x0203_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const audio_codec::RegisterBlock {
        Self::PTR
    }
}
impl Deref for AUDIOCODEC {
    type Target = audio_codec::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for AUDIOCODEC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("AUDIOCODEC").finish()
    }
}
#[doc = "Audio Codec"]
pub mod audio_codec;
#[doc = "Two Wire Interface"]
pub struct TWI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI0 {}
impl TWI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi::RegisterBlock = 0x0250_2000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI0 {
    type Target = twi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI0").finish()
    }
}
#[doc = "Two Wire Interface"]
pub struct TWI1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI1 {}
impl TWI1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi::RegisterBlock = 0x0250_2400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI1 {
    type Target = twi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI1").finish()
    }
}
#[doc = "Two Wire Interface"]
pub struct TWI2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI2 {}
impl TWI2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi::RegisterBlock = 0x0250_2800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI2 {
    type Target = twi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI2").finish()
    }
}
#[doc = "Two Wire Interface"]
pub struct TWI3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TWI3 {}
impl TWI3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const twi::RegisterBlock = 0x0250_2c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const twi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TWI3 {
    type Target = twi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TWI3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TWI3").finish()
    }
}
#[doc = "Two Wire Interface"]
pub mod twi;
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART0 {}
impl UART0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART0 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART0").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART1 {}
impl UART1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_0400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART1 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART1").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART2 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART2 {}
impl UART2 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_0800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART2 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART2 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART2").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART3 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART3 {}
impl UART3 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART3 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART3 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART3").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART4 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART4 {}
impl UART4 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_1000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART4 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART4 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART4").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub struct UART5 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for UART5 {}
impl UART5 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const uart::RegisterBlock = 0x0250_1400 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const uart::RegisterBlock {
        Self::PTR
    }
}
impl Deref for UART5 {
    type Target = uart::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for UART5 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("UART5").finish()
    }
}
#[doc = "Universal Asynchronous Receiver Transmitter"]
pub mod uart;
#[doc = "Serial Peripheral Interface"]
pub struct SPI0 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI0 {}
impl SPI0 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi0::RegisterBlock = 0x0402_5000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi0::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI0 {
    type Target = spi0::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI0 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI0").finish()
    }
}
#[doc = "Serial Peripheral Interface"]
pub mod spi0;
#[doc = "Serial Peripheral Interface Display Bus Interface"]
pub struct SPI_DBI {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for SPI_DBI {}
impl SPI_DBI {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const spi_dbi::RegisterBlock = 0x0402_6000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const spi_dbi::RegisterBlock {
        Self::PTR
    }
}
impl Deref for SPI_DBI {
    type Target = spi_dbi::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for SPI_DBI {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("SPI_DBI").finish()
    }
}
#[doc = "Serial Peripheral Interface Display Bus Interface"]
pub mod spi_dbi;
#[doc = "USB2.0 HOST"]
pub struct USB1 {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for USB1 {}
impl USB1 {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const usb1::RegisterBlock = 0x0420_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const usb1::RegisterBlock {
        Self::PTR
    }
}
impl Deref for USB1 {
    type Target = usb1::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for USB1 {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("USB1").finish()
    }
}
#[doc = "USB2.0 HOST"]
pub mod usb1;
#[doc = "Gerneral Purpose Input/Output"]
pub struct GPIO {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPIO {}
impl GPIO {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpio::RegisterBlock = 0x0200_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpio::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPIO {
    type Target = gpio::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPIO {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPIO").finish()
    }
}
#[doc = "Gerneral Purpose Input/Output"]
pub mod gpio;
#[doc = "General Purpose ADC"]
pub struct GPADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for GPADC {}
impl GPADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const gpadc::RegisterBlock = 0x0200_9000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const gpadc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for GPADC {
    type Target = gpadc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for GPADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("GPADC").finish()
    }
}
#[doc = "General Purpose ADC"]
pub mod gpadc;
#[doc = "Touch Panel ADC"]
pub struct TPADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for TPADC {}
impl TPADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const tpadc::RegisterBlock = 0x0200_9c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const tpadc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for TPADC {
    type Target = tpadc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for TPADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("TPADC").finish()
    }
}
#[doc = "Touch Panel ADC"]
pub mod tpadc;
#[doc = "Low Rate ADC"]
pub struct LRADC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LRADC {}
impl LRADC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const lradc::RegisterBlock = 0x0200_9800 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const lradc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LRADC {
    type Target = lradc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LRADC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LRADC").finish()
    }
}
#[doc = "Low Rate ADC"]
pub mod lradc;
#[doc = "Pulse Width Modulation"]
pub struct PWM {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for PWM {}
impl PWM {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const pwm::RegisterBlock = 0x0200_0c00 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const pwm::RegisterBlock {
        Self::PTR
    }
}
impl Deref for PWM {
    type Target = pwm::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for PWM {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("PWM").finish()
    }
}
#[doc = "Pulse Width Modulation"]
pub mod pwm;
#[doc = "LEDC"]
pub struct LEDC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for LEDC {}
impl LEDC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ledc::RegisterBlock = 0x0200_8000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ledc::RegisterBlock {
        Self::PTR
    }
}
impl Deref for LEDC {
    type Target = ledc::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for LEDC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("LEDC").finish()
    }
}
#[doc = "LEDC"]
pub mod ledc;
#[doc = "Ethernet Medium Access Controller"]
pub struct EMAC {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for EMAC {}
impl EMAC {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const emac::RegisterBlock = 0x0450_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const emac::RegisterBlock {
        Self::PTR
    }
}
impl Deref for EMAC {
    type Target = emac::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for EMAC {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("EMAC").finish()
    }
}
#[doc = "Ethernet Medium Access Controller"]
pub mod emac;
#[doc = "Counsumer Infrared Receiver"]
pub struct CIR_RX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CIR_RX {}
impl CIR_RX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cir_rx::RegisterBlock = 0x0704_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cir_rx::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CIR_RX {
    type Target = cir_rx::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CIR_RX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CIR_RX").finish()
    }
}
#[doc = "Counsumer Infrared Receiver"]
pub mod cir_rx;
#[doc = "Counsumer Infrared Transmitter"]
pub struct CIR_TX {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CIR_TX {}
impl CIR_TX {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const cir_tx::RegisterBlock = 0x0200_3000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const cir_tx::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CIR_TX {
    type Target = cir_tx::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CIR_TX {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CIR_TX").finish()
    }
}
#[doc = "Counsumer Infrared Transmitter"]
pub mod cir_tx;
#[doc = "Crypoto Engine"]
pub struct CE_NS {
    _marker: PhantomData<*const ()>,
}
unsafe impl Send for CE_NS {}
impl CE_NS {
    #[doc = r"Pointer to the register block"]
    pub const PTR: *const ce_ns::RegisterBlock = 0x0304_0000 as *const _;
    #[doc = r"Return the pointer to the register block"]
    #[inline(always)]
    pub const fn ptr() -> *const ce_ns::RegisterBlock {
        Self::PTR
    }
}
impl Deref for CE_NS {
    type Target = ce_ns::RegisterBlock;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        unsafe { &*Self::PTR }
    }
}
impl core::fmt::Debug for CE_NS {
    fn fmt(&self, f: &mut core::fmt::Formatter) -> core::fmt::Result {
        f.debug_struct("CE_NS").finish()
    }
}
#[doc = "Crypoto Engine"]
pub mod ce_ns;
#[no_mangle]
static mut DEVICE_PERIPHERALS: bool = false;
#[doc = r"All the peripherals"]
#[allow(non_snake_case)]
pub struct Peripherals {
    #[doc = "CCU"]
    pub CCU: CCU,
    #[doc = "SYS_CFG"]
    pub SYS_CFG: SYS_CFG,
    #[doc = "RISCV_CFG"]
    pub RISCV_CFG: RISCV_CFG,
    #[doc = "CLINT"]
    pub CLINT: CLINT,
    #[doc = "TIMER"]
    pub TIMER: TIMER,
    #[doc = "HSTIMER"]
    pub HSTIMER: HSTIMER,
    #[doc = "PLIC"]
    pub PLIC: PLIC,
    #[doc = "DMAC"]
    pub DMAC: DMAC,
    #[doc = "THS"]
    pub THS: THS,
    #[doc = "IOMMU"]
    pub IOMMU: IOMMU,
    #[doc = "DSP_MSGBOX"]
    pub DSP_MSGBOX: DSP_MSGBOX,
    #[doc = "RV_MSGBOX"]
    pub RV_MSGBOX: RV_MSGBOX,
    #[doc = "SPINLOCK"]
    pub SPINLOCK: SPINLOCK,
    #[doc = "RTC"]
    pub RTC: RTC,
    #[doc = "TCON_LCD0"]
    pub TCON_LCD0: TCON_LCD0,
    #[doc = "TCON_TV0"]
    pub TCON_TV0: TCON_TV0,
    #[doc = "TVE_TOP"]
    pub TVE_TOP: TVE_TOP,
    #[doc = "TVE"]
    pub TVE: TVE,
    #[doc = "CSIC"]
    pub CSIC: CSIC,
    #[doc = "TVD_TOP"]
    pub TVD_TOP: TVD_TOP,
    #[doc = "TVD0"]
    pub TVD0: TVD0,
    #[doc = "SMHC0"]
    pub SMHC0: SMHC0,
    #[doc = "SMHC1"]
    pub SMHC1: SMHC1,
    #[doc = "SMHC2"]
    pub SMHC2: SMHC2,
    #[doc = "I2S_PCM0"]
    pub I2S_PCM0: I2S_PCM0,
    #[doc = "I2S_PCM1"]
    pub I2S_PCM1: I2S_PCM1,
    #[doc = "I2S_PCM2"]
    pub I2S_PCM2: I2S_PCM2,
    #[doc = "DMIC"]
    pub DMIC: DMIC,
    #[doc = "OWA"]
    pub OWA: OWA,
    #[doc = "AUDIOCODEC"]
    pub AUDIOCODEC: AUDIOCODEC,
    #[doc = "TWI0"]
    pub TWI0: TWI0,
    #[doc = "TWI1"]
    pub TWI1: TWI1,
    #[doc = "TWI2"]
    pub TWI2: TWI2,
    #[doc = "TWI3"]
    pub TWI3: TWI3,
    #[doc = "UART0"]
    pub UART0: UART0,
    #[doc = "UART1"]
    pub UART1: UART1,
    #[doc = "UART2"]
    pub UART2: UART2,
    #[doc = "UART3"]
    pub UART3: UART3,
    #[doc = "UART4"]
    pub UART4: UART4,
    #[doc = "UART5"]
    pub UART5: UART5,
    #[doc = "SPI0"]
    pub SPI0: SPI0,
    #[doc = "SPI_DBI"]
    pub SPI_DBI: SPI_DBI,
    #[doc = "USB1"]
    pub USB1: USB1,
    #[doc = "GPIO"]
    pub GPIO: GPIO,
    #[doc = "GPADC"]
    pub GPADC: GPADC,
    #[doc = "TPADC"]
    pub TPADC: TPADC,
    #[doc = "LRADC"]
    pub LRADC: LRADC,
    #[doc = "PWM"]
    pub PWM: PWM,
    #[doc = "LEDC"]
    pub LEDC: LEDC,
    #[doc = "EMAC"]
    pub EMAC: EMAC,
    #[doc = "CIR_RX"]
    pub CIR_RX: CIR_RX,
    #[doc = "CIR_TX"]
    pub CIR_TX: CIR_TX,
    #[doc = "CE_NS"]
    pub CE_NS: CE_NS,
}
impl Peripherals {
    #[doc = r"Returns all the peripherals *once*"]
    #[inline]
    pub fn take() -> Option<Self> {
        riscv::interrupt::free(|_| {
            if unsafe { DEVICE_PERIPHERALS } {
                None
            } else {
                Some(unsafe { Peripherals::steal() })
            }
        })
    }
    #[doc = r"Unchecked version of `Peripherals::take`"]
    #[inline]
    pub unsafe fn steal() -> Self {
        DEVICE_PERIPHERALS = true;
        Peripherals {
            CCU: CCU {
                _marker: PhantomData,
            },
            SYS_CFG: SYS_CFG {
                _marker: PhantomData,
            },
            RISCV_CFG: RISCV_CFG {
                _marker: PhantomData,
            },
            CLINT: CLINT {
                _marker: PhantomData,
            },
            TIMER: TIMER {
                _marker: PhantomData,
            },
            HSTIMER: HSTIMER {
                _marker: PhantomData,
            },
            PLIC: PLIC {
                _marker: PhantomData,
            },
            DMAC: DMAC {
                _marker: PhantomData,
            },
            THS: THS {
                _marker: PhantomData,
            },
            IOMMU: IOMMU {
                _marker: PhantomData,
            },
            DSP_MSGBOX: DSP_MSGBOX {
                _marker: PhantomData,
            },
            RV_MSGBOX: RV_MSGBOX {
                _marker: PhantomData,
            },
            SPINLOCK: SPINLOCK {
                _marker: PhantomData,
            },
            RTC: RTC {
                _marker: PhantomData,
            },
            TCON_LCD0: TCON_LCD0 {
                _marker: PhantomData,
            },
            TCON_TV0: TCON_TV0 {
                _marker: PhantomData,
            },
            TVE_TOP: TVE_TOP {
                _marker: PhantomData,
            },
            TVE: TVE {
                _marker: PhantomData,
            },
            CSIC: CSIC {
                _marker: PhantomData,
            },
            TVD_TOP: TVD_TOP {
                _marker: PhantomData,
            },
            TVD0: TVD0 {
                _marker: PhantomData,
            },
            SMHC0: SMHC0 {
                _marker: PhantomData,
            },
            SMHC1: SMHC1 {
                _marker: PhantomData,
            },
            SMHC2: SMHC2 {
                _marker: PhantomData,
            },
            I2S_PCM0: I2S_PCM0 {
                _marker: PhantomData,
            },
            I2S_PCM1: I2S_PCM1 {
                _marker: PhantomData,
            },
            I2S_PCM2: I2S_PCM2 {
                _marker: PhantomData,
            },
            DMIC: DMIC {
                _marker: PhantomData,
            },
            OWA: OWA {
                _marker: PhantomData,
            },
            AUDIOCODEC: AUDIOCODEC {
                _marker: PhantomData,
            },
            TWI0: TWI0 {
                _marker: PhantomData,
            },
            TWI1: TWI1 {
                _marker: PhantomData,
            },
            TWI2: TWI2 {
                _marker: PhantomData,
            },
            TWI3: TWI3 {
                _marker: PhantomData,
            },
            UART0: UART0 {
                _marker: PhantomData,
            },
            UART1: UART1 {
                _marker: PhantomData,
            },
            UART2: UART2 {
                _marker: PhantomData,
            },
            UART3: UART3 {
                _marker: PhantomData,
            },
            UART4: UART4 {
                _marker: PhantomData,
            },
            UART5: UART5 {
                _marker: PhantomData,
            },
            SPI0: SPI0 {
                _marker: PhantomData,
            },
            SPI_DBI: SPI_DBI {
                _marker: PhantomData,
            },
            USB1: USB1 {
                _marker: PhantomData,
            },
            GPIO: GPIO {
                _marker: PhantomData,
            },
            GPADC: GPADC {
                _marker: PhantomData,
            },
            TPADC: TPADC {
                _marker: PhantomData,
            },
            LRADC: LRADC {
                _marker: PhantomData,
            },
            PWM: PWM {
                _marker: PhantomData,
            },
            LEDC: LEDC {
                _marker: PhantomData,
            },
            EMAC: EMAC {
                _marker: PhantomData,
            },
            CIR_RX: CIR_RX {
                _marker: PhantomData,
            },
            CIR_TX: CIR_TX {
                _marker: PhantomData,
            },
            CE_NS: CE_NS {
                _marker: PhantomData,
            },
        }
    }
}
