#[doc = "Register `DMAC_EN_REG%s` reader"]
pub struct R(crate::R<DMAC_EN_REG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DMAC_EN_REG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DMAC_EN_REG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DMAC_EN_REG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `DMAC_EN_REG%s` writer"]
pub struct W(crate::W<DMAC_EN_REG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<DMAC_EN_REG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<DMAC_EN_REG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<DMAC_EN_REG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "DMA Channel Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DMA_EN_A {
    #[doc = "0: `0`"]
    DISABLED = 0,
    #[doc = "1: `1`"]
    ENABLED = 1,
}
impl From<DMA_EN_A> for bool {
    #[inline(always)]
    fn from(variant: DMA_EN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DMA_EN` reader - DMA Channel Enable"]
pub type DMA_EN_R = crate::BitReader<DMA_EN_A>;
impl DMA_EN_R {
    #[doc = "Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DMA_EN_A {
        match self.bits {
            false => DMA_EN_A::DISABLED,
            true => DMA_EN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        *self == DMA_EN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        *self == DMA_EN_A::ENABLED
    }
}
#[doc = "Field `DMA_EN` writer - DMA Channel Enable"]
pub type DMA_EN_W<'a> = crate::BitWriter<'a, u32, DMAC_EN_REG_SPEC, DMA_EN_A, 0>;
impl<'a> DMA_EN_W<'a> {
    #[doc = "`0`"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(DMA_EN_A::DISABLED)
    }
    #[doc = "`1`"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(DMA_EN_A::ENABLED)
    }
}
impl R {
    #[doc = "Bit 0 - DMA Channel Enable"]
    #[inline(always)]
    pub fn dma_en(&self) -> DMA_EN_R {
        DMA_EN_R::new((self.bits & 1) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - DMA Channel Enable"]
    #[inline(always)]
    pub fn dma_en(&mut self) -> DMA_EN_W {
        DMA_EN_W::new(self)
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "DMAC Channel Enable Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dmac_en_reg](index.html) module"]
pub struct DMAC_EN_REG_SPEC;
impl crate::RegisterSpec for DMAC_EN_REG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [dmac_en_reg::R](R) reader structure"]
impl crate::Readable for DMAC_EN_REG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [dmac_en_reg::W](W) writer structure"]
impl crate::Writable for DMAC_EN_REG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets DMAC_EN_REG%s to value 0"]
impl crate::Resettable for DMAC_EN_REG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
