#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - HS Timer IRQ Enable Register"]
    pub hs_tmr_irq_en: crate::Reg<hs_tmr_irq_en::HS_TMR_IRQ_EN_SPEC>,
    #[doc = "0x04 - HS Timer Status Register"]
    pub hs_tmr_irq_stas: crate::Reg<hs_tmr_irq_stas::HS_TMR_IRQ_STAS_SPEC>,
    _reserved2: [u8; 0x18],
    #[doc = "0x20 - HS Timer0 Control Register"]
    pub hs_tmr0_ctrl: crate::Reg<hs_tmr0_ctrl::HS_TMR0_CTRL_SPEC>,
    #[doc = "0x24 - HS Timer0 Interval Value Low Register"]
    pub hs_tmr0_intv_lo: crate::Reg<hs_tmr0_intv_lo::HS_TMR0_INTV_LO_SPEC>,
    #[doc = "0x28 - HS Timer0 Interval Value High Register"]
    pub hs_tmr0_intv_hi: crate::Reg<hs_tmr0_intv_hi::HS_TMR0_INTV_HI_SPEC>,
    #[doc = "0x2c - HS Timer0 Current Value Low Register"]
    pub hs_tmr0_curnt_lo: crate::Reg<hs_tmr0_curnt_lo::HS_TMR0_CURNT_LO_SPEC>,
    #[doc = "0x30 - HS Timer0 Current Value High Register"]
    pub hs_tmr0_curnt_hi: crate::Reg<hs_tmr0_curnt_hi::HS_TMR0_CURNT_HI_SPEC>,
    _reserved7: [u8; 0x0c],
    #[doc = "0x40 - HS Timer1 Control Register"]
    pub hs_tmr1_ctrl: crate::Reg<hs_tmr1_ctrl::HS_TMR1_CTRL_SPEC>,
    #[doc = "0x44 - HS Timer1 Interval Value Low Register"]
    pub hs_tmr1_intv_lo: crate::Reg<hs_tmr1_intv_lo::HS_TMR1_INTV_LO_SPEC>,
    #[doc = "0x48 - HS Timer1 Interval Value High Register"]
    pub hs_tmr1_intv_hi: crate::Reg<hs_tmr1_intv_hi::HS_TMR1_INTV_HI_SPEC>,
    #[doc = "0x4c - HS Timer1 Current Value Low Register"]
    pub hs_tmr1_curnt_lo: crate::Reg<hs_tmr1_curnt_lo::HS_TMR1_CURNT_LO_SPEC>,
    #[doc = "0x50 - HS Timer1 Current Value High Register"]
    pub hs_tmr1_curnt_hi: crate::Reg<hs_tmr1_curnt_hi::HS_TMR1_CURNT_HI_SPEC>,
}
#[doc = "HS_TMR_IRQ_EN register accessor: an alias for `Reg<HS_TMR_IRQ_EN_SPEC>`"]
pub type HS_TMR_IRQ_EN = crate::Reg<hs_tmr_irq_en::HS_TMR_IRQ_EN_SPEC>;
#[doc = "HS Timer IRQ Enable Register"]
pub mod hs_tmr_irq_en;
#[doc = "HS_TMR_IRQ_STAS register accessor: an alias for `Reg<HS_TMR_IRQ_STAS_SPEC>`"]
pub type HS_TMR_IRQ_STAS = crate::Reg<hs_tmr_irq_stas::HS_TMR_IRQ_STAS_SPEC>;
#[doc = "HS Timer Status Register"]
pub mod hs_tmr_irq_stas;
#[doc = "HS_TMR0_CTRL register accessor: an alias for `Reg<HS_TMR0_CTRL_SPEC>`"]
pub type HS_TMR0_CTRL = crate::Reg<hs_tmr0_ctrl::HS_TMR0_CTRL_SPEC>;
#[doc = "HS Timer0 Control Register"]
pub mod hs_tmr0_ctrl;
#[doc = "HS_TMR0_INTV_LO register accessor: an alias for `Reg<HS_TMR0_INTV_LO_SPEC>`"]
pub type HS_TMR0_INTV_LO = crate::Reg<hs_tmr0_intv_lo::HS_TMR0_INTV_LO_SPEC>;
#[doc = "HS Timer0 Interval Value Low Register"]
pub mod hs_tmr0_intv_lo;
#[doc = "HS_TMR0_INTV_HI register accessor: an alias for `Reg<HS_TMR0_INTV_HI_SPEC>`"]
pub type HS_TMR0_INTV_HI = crate::Reg<hs_tmr0_intv_hi::HS_TMR0_INTV_HI_SPEC>;
#[doc = "HS Timer0 Interval Value High Register"]
pub mod hs_tmr0_intv_hi;
#[doc = "HS_TMR0_CURNT_LO register accessor: an alias for `Reg<HS_TMR0_CURNT_LO_SPEC>`"]
pub type HS_TMR0_CURNT_LO = crate::Reg<hs_tmr0_curnt_lo::HS_TMR0_CURNT_LO_SPEC>;
#[doc = "HS Timer0 Current Value Low Register"]
pub mod hs_tmr0_curnt_lo;
#[doc = "HS_TMR0_CURNT_HI register accessor: an alias for `Reg<HS_TMR0_CURNT_HI_SPEC>`"]
pub type HS_TMR0_CURNT_HI = crate::Reg<hs_tmr0_curnt_hi::HS_TMR0_CURNT_HI_SPEC>;
#[doc = "HS Timer0 Current Value High Register"]
pub mod hs_tmr0_curnt_hi;
#[doc = "HS_TMR1_CTRL register accessor: an alias for `Reg<HS_TMR1_CTRL_SPEC>`"]
pub type HS_TMR1_CTRL = crate::Reg<hs_tmr1_ctrl::HS_TMR1_CTRL_SPEC>;
#[doc = "HS Timer1 Control Register"]
pub mod hs_tmr1_ctrl;
#[doc = "HS_TMR1_INTV_LO register accessor: an alias for `Reg<HS_TMR1_INTV_LO_SPEC>`"]
pub type HS_TMR1_INTV_LO = crate::Reg<hs_tmr1_intv_lo::HS_TMR1_INTV_LO_SPEC>;
#[doc = "HS Timer1 Interval Value Low Register"]
pub mod hs_tmr1_intv_lo;
#[doc = "HS_TMR1_INTV_HI register accessor: an alias for `Reg<HS_TMR1_INTV_HI_SPEC>`"]
pub type HS_TMR1_INTV_HI = crate::Reg<hs_tmr1_intv_hi::HS_TMR1_INTV_HI_SPEC>;
#[doc = "HS Timer1 Interval Value High Register"]
pub mod hs_tmr1_intv_hi;
#[doc = "HS_TMR1_CURNT_LO register accessor: an alias for `Reg<HS_TMR1_CURNT_LO_SPEC>`"]
pub type HS_TMR1_CURNT_LO = crate::Reg<hs_tmr1_curnt_lo::HS_TMR1_CURNT_LO_SPEC>;
#[doc = "HS Timer1 Current Value Low Register"]
pub mod hs_tmr1_curnt_lo;
#[doc = "HS_TMR1_CURNT_HI register accessor: an alias for `Reg<HS_TMR1_CURNT_HI_SPEC>`"]
pub type HS_TMR1_CURNT_HI = crate::Reg<hs_tmr1_curnt_hi::HS_TMR1_CURNT_HI_SPEC>;
#[doc = "HS Timer1 Current Value High Register"]
pub mod hs_tmr1_curnt_hi;
