use cosmwasm_std::StdError;
use thiserror::Error;

#[derive(Error, Debug, PartialEq)]
pub enum ContractError {
    #[error("{0}")]
    Std(#[from] StdError),

    #[error("Unauthorized")]
    Unauthorized {},

    #[error("CannotSetOwnAccount")]
    CannotSetOwnAccount {},

    #[error("InvalidZeroAmount")]
    InvalidZeroAmount {},

    #[error("Expired")]
    Expired {},

    #[error("NoAllowance")]
    NoAllowance {},

    #[error("CannotExceedCap")]
    CannotExceedCap {},

    #[error("LogoTooBig")]
    LogoTooBig {},
    
    #[error("InvalidXmlPreamble")]
    InvalidXmlPreamble {},
    
    #[error("InvalidPngHeader")]
    InvalidPngHeader {},
}

impl From<cw20_base::ContractError> for ContractError {
    fn from(err: cw20_base::ContractError) -> Self {
        match err {
            cw20_base::ContractError::Std(error) => ContractError::Std(error),
            cw20_base::ContractError::Unauthorized {} => ContractError::Unauthorized {},
            cw20_base::ContractError::CannotSetOwnAccount {} => {
                ContractError::CannotSetOwnAccount {}
            }
            cw20_base::ContractError::InvalidZeroAmount {} => ContractError::InvalidZeroAmount {},
            cw20_base::ContractError::Expired {} => ContractError::Expired {},
            cw20_base::ContractError::NoAllowance {} => ContractError::NoAllowance {},
            cw20_base::ContractError::CannotExceedCap {} => ContractError::CannotExceedCap {},


            cw20_base::ContractError::LogoTooBig {} => ContractError::LogoTooBig {},
            cw20_base::ContractError::InvalidXmlPreamble {} => ContractError::InvalidXmlPreamble {},
            cw20_base::ContractError::InvalidPngHeader {} => ContractError::InvalidPngHeader {}
        }
    }
}