use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use cosmwasm_std::Addr;
use cw_storage_plus::Item;

#[derive(Serialize, Deserialize, Clone, Debug, PartialEq, JsonSchema)]
pub struct State {
    pub cash: i32,
    pub coins: i32,
    pub price: i32,
    pub owner: Addr,
}

pub const STATE: Item<State> = Item::new("state");
