// Copyright (c) 2018-2020  Brendan Molloy <brendan@bbqsrc.net>
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

use std;
use std::path::Path;

use gherkin;

use crate::OutputVisitor;
use crate::TestResult;

pub struct DebugOutput;

impl OutputVisitor for DebugOutput {
    fn new() -> Self
    where
        Self: Sized,
    {
        DebugOutput
    }

    fn visit_start(&mut self) {
        println!("visit_start");
    }

    fn visit_feature(&mut self, feature: &gherkin::Feature, path: &Path) {
        println!("visit_feature {} {}", feature.name, path.display());
    }

    fn visit_feature_end(&mut self, feature: &gherkin::Feature) {
        println!("visit_feature_end {}", feature.name);
    }

    fn visit_feature_error(&mut self, path: &Path, error: &gherkin::Error) {
        println!("visit_feature_error {} {}", path.display(), error);
    }

    fn visit_rule(&mut self, rule: &gherkin::Rule) {
        println!("visit_rule {}", rule.name);
    }

    fn visit_rule_end(&mut self, rule: &gherkin::Rule) {
        println!("visit_rule_end {}", rule.name);
    }

    fn visit_scenario(&mut self, _rule: Option<&gherkin::Rule>, scenario: &crate::Scenario) {
        println!("visit_scenario {}", scenario.name);
    }

    fn visit_scenario_end(&mut self, _rule: Option<&gherkin::Rule>, scenario: &crate::Scenario) {
        println!("visit_scenario_end {}", scenario.name);
    }

    fn visit_scenario_skipped(
        &mut self,
        _rule: Option<&gherkin::Rule>,
        scenario: &crate::Scenario,
    ) {
        println!("visit_scenario_skipped {}", scenario.name);
    }

    fn visit_step(
        &mut self,
        _rule: Option<&gherkin::Rule>,
        _scenario: &crate::Scenario,
        step: &crate::Step,
    ) {
        println!("visit_step {} {}", step.raw_type, step.value);
    }

    fn visit_step_result(
        &mut self,
        _rule: Option<&gherkin::Rule>,
        _scenario: &crate::Scenario,
        step: &crate::Step,
        result: &TestResult,
    ) {
        println!(
            "visit_step_result {} {} - {:?}",
            step.raw_type, step.value, result
        );
    }

    fn visit_finish(&mut self) {
        println!("visit_finish");
    }

    fn visit_step_resolved<'a, W: crate::World>(
        &mut self,
        _step: &crate::Step,
        test: &crate::TestCaseType<'a, W>,
    ) {
        println!("visit_step_resolved {:?}", test);
    }
}
