# Send a single command to all panes without
# having to toggle on and off the
# synchronize-panes option manually
function _ctrlg_tmux_send_all_panes
    if test -z "$TMUX"
        eval "$argv"
    else
        set -l current_pane (tmux display-message -p '#P')
        for pane in (tmux list-panes -F '#P')
            if [ "$pane" = "$current_pane" ]
                eval "$argv"
            else
                tmux send-keys -t "$pane" "  $argv" Enter
            end
        end
    end
end

function _ctrlg_search_and_go
    set -l ctrlg_output (ctrlg find)
    set -l ctrlg_selected_dir (string replace "ctrlg_edit:" "" "$ctrlg_output")
    set -l ctrlg_selected_dir (string replace "ctrlg_notmux:" "" "$ctrlg_output")
    set -l ctrlg_selected_dir (string replace "ctrlg_insert:" "" "$ctrlg_output")
    if test -n "$ctrlg_selected_dir" && ! string match -q -- "ctrlg_insert:*" "$ctrlg_output"
        if [ "$CTRLG_TMUX" = true ] && ! string match -q -- "ctrlg_notmux:*" "$ctrlg_output"
            _ctrlg_tmux_send_all_panes "cd $ctrlg_selected_dir && commandline -f repaint && clear"
        else
            cd "$ctrlg_selected_dir"
            commandline -f repaint
            clear
        end

        if string match -q -- "ctrlg_edit:*" "$ctrlg_output" && test -n "$EDITOR"
            $EDITOR
        end
    else if string match -q -- "ctrlg_insert:*" "$ctrlg_output"
        commandline -r "$ctrlg_selected_dir"
    end

    commandline -f repaint
end

if test -z "$CTRLG_NOBIND"
    bind \a _ctrlg_search_and_go
    for mode in insert default normal
        bind -M $mode \a _ctrlg_search_and_go
    end
end
