# CtrlG - A Command Line Context Switcher

CtrlG is a tool to quickly switch contexts to another directory, using a fuzzy finder.
If enabled, `ctrlg` can `cd` all split panes in the current window of a `tmux` session
to the selected directory. Press <kbd>ctrl</kbd> + <kbd>g</kbd> to fuzzy find directories,
configured by globbing patterns.

![demo](https://github.com/mrjones2014/ctrlg/raw/master/demo.gif)

By default, only `~/git/*` is searched. To change this or add additional
directories to search, see [configuration](#configuration).

## Install

Make sure you have `cargo` installed. If not, install it from [rustup.rs](https://rustup.rs).
Then install the `ctrlg` CLI by running:

```sh
cargo install ctrlg
```

Once the CLI is installed, you will need to set up the key binding depending on your shell.
Alternatively, you can disable the default keybind by setting `$CTRLG_NOBIND` to `true`
before running the init script, then set up your own keybind to call `_ctrlg_search_and_go`.

### Fish

```fish
echo 'ctrlg init fish | source' >> ~/.config/fish/config.fish
```

### Zsh

```zsh
echo 'eval "$(ctrlg init zsh)"' >> ~/.zshrc
```

### Bash

```bash
echo 'eval "$(ctrlg init bash)"' >> ~/.bashrc
```

## Tmux Integration

To make `ctrlg` send the `cd` command to all split panes in the current `tmux`
window, set the environment variable `CTRLG_TMUX` to `true`.

### Fish

```fish
set CTRLG_TMUX true
```

### Bash or Zsh

```bash
export CTRLG_TMUX=true
```

## Configuration

`ctrlg` will look for a configuration file at `~/.config/ctrlg/config.yml`. The default
configuration is shown below:

```yaml
# configure what directories to list in the fuzzy finder
# can be any list of globbing patterns, will only show directories
# not files
search_dirs:
  - "~/git/*"
# globbing patterns of files to find for use as preview
# see below for more details on previews
preview_files:
  - "README.*"
# enable or disable the preview window
previews: true
# force using or not using `bat` for previews
# this represents the default but in an actual
# config file, this should just be `true` or `false`
preview_with_bat: [true if `bat` is installed, false otherwise]
# force using or not using `exa` for preview fallback when no
# matching `preview_files` are found
# this represents the default but in an actual
# config file, this should just be `true` or `false`
preview_fallback_exa: [true if `exa` is installed, false otherwise]
```

Any configuration values can be overridden by passing them as arguments to the CLI.
When passing arguments to the CLI, replace `_` with `-`, e.g. `preview_with_bat`
should be passed to the CLI as `--preview-with-bat`.
See `ctrlg --help` and `ctrlg find --help`.

### Previews

Previews, if enabled, are generated by rendering the first file in each directory
matching any of the specified `preview_files` globbing patterns. If a matching file
is found, it will be rendered with [bat](https://github.com/sharkdp/bat) by default
if `bat` is installed, otherwise it will be rendered with `cat`. You can force using
or not using `bat` with the `preview_with_bat` option. You can default to always
using the fallback instead of rendering a file by setting an empty list of globbing
patterns, like: `preview_files: []`.

If no matching preview files are found, the directory listing is used as the preview. By
default, directory contents are listed using [exa](https://github.com/ogham/exa) by default
if `exa` is installed, otherwise contents are listed using `ls`. You can force using or not
using `exa` as the fallback preview using the `preview_fallback_exa` option.
