// Copyright (C) 2021 Robin Krahl <robin.krahl@ireas.org>
// SPDX-License-Identifier: CC0-1.0

//! Executes the wink command on all CTAPHID devices.

fn main() -> Result<(), ctaphid::error::Error> {
    env_logger::init();

    let devices = ctaphid::list()?;
    for device in &devices {
        let device = devices.connect(device)?;
        device.wink()?;
    }
    Ok(())
}
