<!---
Copyright (C) 2021 Robin Krahl <robin.krahl@ireas.org>
SPDX-License-Identifier: CC0-1.0
-->

# cptahid-rs

A Rust implementation of the CTAPHID protocol.

The `ctaphid` crates provides access to devices implementing the [CTAPHID
protocol][spec].  It is still work in progress and only supports the following
commands:

- fully supported:
  - ping
  - wink
  - error
  - vendor-specific commands
- partially supported:
  - init (not all response fields are read, the nonce is hardcoded)

[spec]: https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#usb

Please see the [API documentation][docs] for more information.

[docs]: https://docs.rs/ctaphid

## Contributing

Contributions to this project are welcome!  Please submit patches to the
mailing list [~ireas/public-inbox@lists.sr.ht][] ([archive][]) using the
`[PATCH cptahid-rs]` subject prefix.  For more information, see the
[Contributing Guide][].

[~ireas/public-inbox@lists.sr.ht]: mailto:~ireas/public-inbox@lists.sr.ht
[archive]: https://lists.sr.ht/~ireas/public-inbox
[Contributing Guide]: https://man.sr.ht/~ireas/guides/contributing.md

## Contact

For bug reports, feature requests and other messages, please send a mail to
[~ireas/public-inbox@lists.sr.ht][] ([archive][]) using the `[ctaphid-rs]`
prefix in the subject.

## License

This project is dual-licensed under the [Apache-2.0][] and [MIT][] licenses.
The documentation and examples contained in this repository are licensed under
the [Creative Commons Zero][CC0] license.  You can find a copy of the license
texts in the `LICENSES` directory.

`ctaphid-rs` complies with [version 3.0 of the REUSE specification][reuse].

[Apache-2.0]: https://opensource.org/licenses/Apache-2.0
[MIT]: https://opensource.org/licenses/MIT
[CC0]: https://creativecommons.org/publicdomain/zero/1.0/
[reuse]: https://reuse.software/practices/3.0/
