// Copyright (C) 2021 Robin Krahl <robin.krahl@ireas.org>
// SPDX-License-Identifier: CC0-1.0

//! Lists all available CTAPHID devices and tries to ping them.

fn main() -> Result<(), ctaphid::error::Error> {
    env_logger::init();

    let devices = ctaphid::list()?;
    println!("Found {} CTAPHID devices", devices.len());
    for device in &devices {
        let device = devices.connect(device)?;
        println!("- {:x?}", device);
        device.ping(&[0xaa; 256])?;
    }
    Ok(())
}
