use crate::data::ast::Interval;

use serde::{Deserialize, Serialize};
use std::hash::Hash;

////////////////////////////////////////////////////////////////////////////////
// STRUCTURE
////////////////////////////////////////////////////////////////////////////////

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize, Hash)]
pub struct Position {
    pub flow: String,
    pub interval: Interval,
}

////////////////////////////////////////////////////////////////////////////////
// TRAIT FUNCTION
////////////////////////////////////////////////////////////////////////////////

impl Default for Position {
    fn default() -> Self {
        Self {
            flow: String::default(),
            interval: Interval::default(),
        }
    }
}

////////////////////////////////////////////////////////////////////////////////
// PUBLIC FUNCTION
////////////////////////////////////////////////////////////////////////////////

impl Position {
    pub fn new(interval: Interval, flow: &str) -> Self {
        Self {
            flow: flow.to_owned(),
            interval,
        }
    }
}
