use crate::data::ast::Interval;

use std::hash::Hash;
use serde::{Deserialize, Serialize};

////////////////////////////////////////////////////////////////////////////////
// STRUCTURE
////////////////////////////////////////////////////////////////////////////////

#[derive(Debug, Clone, PartialEq, Serialize, Deserialize, Hash)]
pub struct Position {
    pub flow: String,
    pub interval: Interval,
}

////////////////////////////////////////////////////////////////////////////////
// TRAIT FUNCTION
////////////////////////////////////////////////////////////////////////////////

impl Default for Position {
    fn default() -> Self {
        Self {
            flow: String::default(),
            interval: Interval::default(),
        }
    }
}

////////////////////////////////////////////////////////////////////////////////
// PUBLIC FUNCTION
////////////////////////////////////////////////////////////////////////////////

impl Position {
    pub fn new(interval: Interval, flow: &str) -> Self {
        Self {
            flow: flow.to_owned(),
            interval,
        }
    }
}