use std::path::Path;

use clap::Parser;

use csbindinglib::{generate_csharp, walk_folder, write_file};

#[derive(Parser)]
#[clap(author, version, about, long_about = None )]

struct Cli {
    /// The folders to start checking from there.
    scan_folder: String,

    // Folder to output the files in.
    #[clap(short, default_value_t = String::from("."))]
    output_folder: String,

    /// Folders/Files excluded from search
    #[clap(short, long)]
    excluded: Vec<String>,

    /// Using this value, you can generate code with the proper dll name from the start.
    /// You can always change it later
    #[clap(short, long)]
    dllname: Option<String>,

    /// If you want the functions and/or object inside a namespace, add it with this flag
    #[clap(short, long)]
    namespace: Option<String>,
}

fn process() -> Result<(), String> {
    let cli = Cli::parse();
    let mut files = walk_folder(cli.scan_folder, &cli.excluded)?;

    let dllname = cli.dllname.unwrap_or_else(|| "<dllname>".to_string());

    while let Some(f) = files.pop() {
        let script = generate_csharp(f.as_str(), &dllname, &cli.namespace)?;
        let filename = Path::new(&f).file_name().unwrap().to_str().unwrap();
        write_file(filename, &cli.output_folder, script)?;
        // let is_new = script.contains(""x"")
    }

    Ok(())
}

fn main() -> Result<(), ()> {
    if let Err(m) = process() {
        println!("Error: {}", m);
    }

    Ok(())
}
