#[cfg(test)]
mod random_str {
    use cs_utils::random_str;
    use rstest::rstest;
    use std::ops::Range;

    #[rstest]
    #[case(32)]
    #[case(64)]
    fn generates_random_string(
        #[case] items_count: usize,
    ) {
        use std::collections::HashSet;

        let mut set = HashSet::new();

        for _i in 0..items_count {
            set.insert(random_str(4 * items_count));
        }

        assert_eq!(
            set.len(),
            items_count,
            "Must generate unique items.",
        );
    }

    #[rstest]
    #[case(1..64)]
    #[case(64..128)]
    #[case(128..256)]
    #[case(256..512)]
    fn generates_random_string_with_length(
        #[case] range: Range<usize>,
    ) {
        for len in range {
            let result = random_str(len);
            
            assert_eq!(
                result.len(),
                len,
                "Must generate string of given length.",
            );
        }
    }

    #[test]
    #[should_panic]
    fn panics_if_len_is_zero() {
        random_str(0);
    }
}
