#[cfg(test)]
pub use rstest::rstest;

#[cfg(test)]
macro_rules! signed_tests {
    ($i:ident) => {
        paste::item! {
            mod [< $i >] {
                pub use super::*;

                #[rstest]
                #[case(0, 1)]
                #[case(10, 20)]
                #[case(-10, 10)]
                #[case(-20, -10)]
                fn inclusive(
                    #[case] min: $i,
                    #[case] max: $i,
                ) {
                    use cs_utils::random_number;
            
                    let delta: usize = (max - min) as usize;
            
                    let numbers_to_generate: usize = (10 * delta) as usize;
                    let mut generated_numbers = vec![];

                    for _ in 0..numbers_to_generate {
                        generated_numbers.push(
                            random_number(min..=max),
                        );
                    }
            
                    assert!(
                        generated_numbers.contains(&min),
                        "Must contain the min value of \"{}\".", &min,
                    );
            
                    assert!(
                        generated_numbers.contains(&max),
                        "Must contain the max value of \"{}\".", &max,
                    );
            
                    let iter = generated_numbers.iter();
                    let generated_min = *iter.clone().min().unwrap();
                    let generated_max = *iter.clone().max().unwrap();
            
                    assert_eq!(
                        generated_min,
                        min,
                        "Min value must be \"{}\".", &generated_min,
                    );
            
                    assert_eq!(
                        generated_max,
                        max,
                        "Max value must be \"{}\".", &generated_max,
                    );
                }

                #[rstest]
                #[case(0, 1)]
                #[case(10, 20)]
                #[case(-10, 10)]
                #[case(-20, -10)]
                fn non_inclusive(
                    #[case] min: $i,
                    #[case] max: $i,
                ) {
                    use cs_utils::random_number;
            
                    let delta: usize = (max - min) as usize;
            
                    let numbers_to_generate: usize = (10 * delta) as usize;
                    let mut generated_numbers = vec![];

                    for _ in 0..numbers_to_generate {
                        generated_numbers.push(
                            random_number(min..=max),
                        );
                    }
            
                    assert!(
                        generated_numbers.contains(&min),
                        "Must contain the min value of \"{}\".", &min,
                    );
            
                    assert!(
                        generated_numbers.contains(&max),
                        "Must contain the max value of \"{}\".", &max,
                    );
            
                    let iter = generated_numbers.iter();
                    let generated_min = *iter.clone().min().unwrap();
                    let generated_max = *iter.clone().max().unwrap();
            
                    assert_eq!(
                        generated_min,
                        min,
                        "Min value must be \"{}\".", &generated_min,
                    );
            
                    assert_eq!(
                        generated_max,
                        max,
                        "Max value must be \"{}\".", &generated_max,
                    );
                }
            }
        }
    };
}

macro_rules! unsigned_tests {
    ($i:ident) => {
        paste::item! {
            mod [< $i >] {
                pub use super::*;

                #[rstest]
                #[case(0, 1)]
                #[case(0, 10)]
                #[case(0, 20)]
                #[case(10, 20)]
                fn inclusive(
                    #[case] min: $i,
                    #[case] max: $i,
                ) {
                    use cs_utils::random_number;
            
                    let delta: usize = (max - min) as usize;
            
                    let numbers_to_generate: usize = (10 * delta) as usize;
                    let mut generated_numbers = vec![];

                    for _ in 0..numbers_to_generate {
                        generated_numbers.push(
                            random_number(min..=max),
                        );
                    }

                    assert!(
                        generated_numbers.contains(&min),
                        "Must contain the min value of \"{}\".", &min,
                    );
            
                    assert!(
                        generated_numbers.contains(&max),
                        "Must contain the max value of \"{}\".", &max,
                    );
            
                    let iter = generated_numbers.iter();
                    let generated_min = *iter.clone().min().unwrap();
                    let generated_max = *iter.clone().max().unwrap();
            
                    assert_eq!(
                        generated_min,
                        min,
                        "Min value must be \"{}\".", &generated_min,
                    );
            
                    assert_eq!(
                        generated_max,
                        max,
                        "Max value must be \"{}\".", &generated_max,
                    );
                }

                #[rstest]
                #[rstest]
                #[case(0, 1)]
                #[case(0, 10)]
                #[case(0, 20)]
                #[case(10, 20)]
                fn non_inclusive(
                    #[case] min: $i,
                    #[case] max: $i,
                ) {
                    use cs_utils::random_number;
            
                    let delta: usize = (max - min) as usize;
            
                    let numbers_to_generate: usize = (10 * delta) as usize;
                    let mut generated_numbers = vec![];

                    for _ in 0..numbers_to_generate {
                        generated_numbers.push(
                            random_number(min..=max),
                        );
                    }
            
                    assert!(
                        generated_numbers.contains(&min),
                        "Must contain the min value of \"{}\".", &min,
                    );
            
                    assert!(
                        generated_numbers.contains(&max),
                        "Must contain the max value of \"{}\".", &max,
                    );
            
                    let iter = generated_numbers.iter();
                    let generated_min = *iter.clone().min().unwrap();
                    let generated_max = *iter.clone().max().unwrap();
            
                    assert_eq!(
                        generated_min,
                        min,
                        "Min value must be \"{}\".", &generated_min,
                    );
            
                    assert_eq!(
                        generated_max,
                        max,
                        "Max value must be \"{}\".", &generated_max,
                    );
                }
            }
            }
    };
}

#[cfg(test)]
mod random_number {
    pub use super::*;

    mod signed {
        pub use super::*;

        signed_tests!(i8);
        signed_tests!(i16);
        signed_tests!(i32);
        signed_tests!(i64);
        signed_tests!(i128);
    }

    mod unsigned {
        pub use super::*;

        unsigned_tests!(u8);
        unsigned_tests!(u16);
        unsigned_tests!(u32);
        unsigned_tests!(u64);
        unsigned_tests!(u128);
    }
}
