use rand::{Rng, distributions::Alphanumeric};

/// Function to generate a random string, `length` characters long.
/// 
/// ## Panics
/// 
/// Panics if length of `0` passed, as its impossible to have a zero-length `random` string.
/// 
/// ## Arguments
/// 
/// * `length` - resulting random string length, must be greater than 0.
/// 
/// ## Examples
/// 
/// ```
/// use cs_utils::random_str;
/// 
/// let result = random_str(8);
/// 
/// println!("random string \"{}\" generated", &result);
/// 
/// assert_eq!(
///     result.len(),
///     8,
/// );
/// ```
pub fn random_str(length: usize) -> String {
    assert!(
        length > 0,
        "Length parameter should be greater than 0.",
    );

    return rand::thread_rng()
        .sample_iter(&Alphanumeric)
        .take(length)
        .map(char::from)
        .collect();
}
