use rand::distributions::uniform::{SampleRange, SampleUniform};
use rand::{thread_rng, Rng};

/// Generate a random number in (min, max) range.
/// 
/// ## Arguments
/// 
/// * `range` - `(min..max)` (or `(min..=max)`) range of numbers
/// 
/// ## Examples
/// 
/// ### Inclusive range
/// ```
/// let number = cs_utils::random_number(3..=9);
/// 
/// assert!(number >= 3);
/// assert!(number <= 9);
/// ```
/// 
/// ### Non-inclusive range
/// ```
/// let number = cs_utils::random_number(1..5);
/// 
/// assert!(number >= 1);
/// assert!(number < 5);
/// ```
/// 
pub fn random_number<T, R>(range: R) -> T where T: SampleUniform, R: SampleRange<T> {
    let mut rng = thread_rng();
    let result: T = rng.gen_range(range);

    return result;
}
