use std::io::Error;

use bytes::BytesMut;
use serde::{Serialize, de::DeserializeOwned};
use tokio_util::codec::Encoder;

use super::GenericCodec;

impl<T: Serialize + DeserializeOwned> Encoder<T> for GenericCodec<T> {
    type Error = Error;

    fn encode(
        &mut self,
        message: T,
        dist_buff: &mut BytesMut,
    ) -> Result<(), Self::Error> {
        let bytes = serde_json::to_string(&message)
            .expect("Cannot serialize message to bytes.");
        
        return Encoder::encode(
            &mut self.length_delimited_codec, 
            bytes.into(),
            dist_buff,
        );
    }
}
