use std::io::{Error, ErrorKind};

use bytes::BytesMut;
use serde::{Serialize, de::DeserializeOwned};
use tokio_util::codec::Encoder;

use super::GenericLinesCodec;

impl<T: Serialize + DeserializeOwned> Encoder<T> for GenericLinesCodec<T> {
    type Error = Error;

    fn encode(
        &mut self,
        message: T,
        dist_buff: &mut BytesMut,
    ) -> Result<(), Self::Error> {
        let data = serde_json::to_string(&message)
            .expect("Cannot serialize message to bytes.");
        
        let result = Encoder::encode(
            &mut self.length_delimited_codec, 
            data,
            dist_buff,
        );

        match result {
            Ok(_) => return Ok(()),
            Err(err) => return Err(
                Error::new(
                    ErrorKind::InvalidData,
                    format!("Cannot encode message: {:?}.", err),
                ),
            ),
        };
    }
}
