
/// Test if an item implements `Debug` trait.
/// 
/// ### Examples
///
/// - Debug item:
/// 
/// ```
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_debug;
///
///     #[derive(Debug)]
///     struct TestStruct {}
/// 
///     // compiles fine
///     implements_debug(TestStruct {});
/// }
/// ```
/// 
/// - Non-Debug item:
/// 
/// ```compile_fail
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_debug;
///     
///     // don't derive Debug
///     struct TestStruct {}
/// 
///     // does not compile
///     implements_debug(TestStruct {});
/// }
/// ```
pub fn implements_debug<T: std::fmt::Debug>(item: T) -> T {
    return item;
}
