use cs_utils::{random_str, traits::Random, random_number, test::{random_vec, random_vec_rg}};

/// Examples for the `random_vec`/`random_vec_rg` utilities.
fn main() {
    #[derive(Debug)]
    struct SomeStruct {
        _id: u16,
        _name: String,
    }
    
    impl Random for SomeStruct {
        fn random() -> Self {
            return SomeStruct {
                _id: random_number(0..=u16::MAX),
                _name: random_str(10),
            };
        }
    }

    println!("\n-- `random_vec` utility example:\n");
    
    let items_count = random_number(3..=7);
    let result: Vec<SomeStruct> = random_vec(items_count);
    
    assert_eq!(
        result.len() as u32,
        items_count,
        "Must generate at {} items.", &items_count,
    );
    
    println!("{:?}", &result);


    println!("\n-- `random_vec_rg` utility example:\n");

    let result: Vec<SomeStruct> = random_vec_rg(3..=7);
    
    assert!(
        result.len() >= 3,
        "Must generate at least 3 items.",
    );

    assert!(
        result.len() <= 7,
        "Must generate at most 7 items.",
    );
    
    println!("{:?}", &result);
}
