fn main() {
    // either "test" or "all" features must be enabled
    #[cfg(any(feature = "test", feature = "all"))] {
        // Send
        {
            use cs_utils::test::implements_send;
   
            // compiles OK
            {
                struct TestStruct {}
        
                implements_send(TestStruct {});
            }

            // uncomment, will not compile
            {
                // struct NonSendTestStruct {
                //     rc: Rc<u8>,
                // }
                // implements_send(NonSendTestStruct { rc: Rc::new(2) });
            }
        }

        // Sync
        {
            use cs_utils::test::implements_sync;
   
            // compiles OK
            {
                struct TestStruct {}
        
                implements_sync(TestStruct {});
            }

            // uncomment, will not compile
            {
                // struct NonSyncTestStruct {
                //     rc: Rc<u8>,
                // }
                // implements_sync(NonSyncTestStruct { rc: Rc::new(2) });
            }
        }

        // Sync
        {
            use cs_utils::test::implements_sync;
   
            // compiles OK
            {
                struct TestStruct {}
        
                implements_sync(TestStruct {});
            }

            // uncomment, will not compile
            {
                // struct NonSyncTestStruct {
                //     rc: Rc<u8>,
                // }
                // implements_sync(NonSyncTestStruct { rc: Rc::new(2) });
            }
        }

        // `Clone` trait
        {
            use cs_utils::test::implements_clone;
   
            // compiles OK
            {
                #[derive(Clone)]
                struct TestStruct {}
        
                implements_clone(TestStruct {});
            }

            // uncomment, will not compile
            {
                // struct NonCloneTestStruct {}
                // implements_clone(NonCloneTestStruct { });
            }
        }

        // `Debug` trait
        {
            use cs_utils::test::implements_debug;
   
            // compiles OK
            {
                #[derive(Debug)]
                struct TestStruct {}
        
                implements_debug(TestStruct {});
                format!("{:?}", TestStruct {});
            }

            // uncomment, will not compile
            {
                // struct NonDebugTestStruct {}
                // implements_debug(NonDebugTestStruct { });
                // format!("{:?}", NonDebugTestStruct {});
            }
        }
    }
}
