use cs_utils::{drain_filter, random_number};

fn main() {
    println!("\n## `drain_filter` utility example:\n");

    let mut test_vector = vec![
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
        random_number(0..=1),
    ];

    println!("test vector: {:?}", &test_vector);
    
    let removed_items = drain_filter(
        &mut test_vector,
        |el| {
            return *el == 1;
        },
    );
    
    assert!(
        !removed_items.contains(&0),
        "Removed items must not contain \"0\" values.",
    );

    println!("removed items: {:?}", &removed_items);
    
    assert!(
        !test_vector.contains(&1),
        "Removed items must not contain \"1\" values.",
    );

    println!("original vector: {:?}", &test_vector);
}
