use tokio::io::duplex;

#[tokio::main]
async fn main() {
    // either both `async` and `test` features must be enabled or the `all` one
    #[cfg(any(all(feature = "async", feature = "test"), feature = "all"))]
    {
        use cs_utils::{futures::test::test_async_stream, random_str_rg};

        println!("\n## `test_async_stream` utility example:");
        
        let (channel1, channel2) = duplex(4096);

        // create test data
        let test_data = random_str_rg(1024..=25600);

        println!(
            ">> sending random string data: \"{}..\", total length is {:?}",
            &test_data[..16],
            &test_data.len(),
        );

        test_async_stream(
            Box::new(channel1),
            Box::new(channel2),
            test_data,
        ).await;

        println!("👌 data transfer succeeded");
    }
}