
/// Test if an item implements `Send` trait.
/// 
/// ### Examples
///
/// - Send item:
/// 
/// ```
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_send;
///
///     // Send is auto implemented
///     struct TestStruct {}
/// 
///     // compiles fine
///     implements_send(TestStruct {});
/// }
/// ```
/// 
/// - Non-Send item:
/// 
/// ```compile_fail
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_send;
/// 
///     struct TestStruct {
///         // make it not Send
///         rc: std::rc::Rc<u8>,
///     }
/// 
///     // does not compile
///     implements_send(TestStruct {});
/// }
/// ```
pub fn implements_send<T: Send>(item: T) -> T {
    return item;
}
