
/// Test if an item implements `Clone` trait.
/// 
/// ### Examples
///
/// - Clone item:
/// 
/// ```
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_clone;
///
///     #[derive(Clone)]
///     struct TestStruct {}
/// 
///     // compiles fine
///     implements_clone(TestStruct {});
/// }
/// ```
/// 
/// - Non-Clone item:
/// 
/// ```compile_fail
/// // either "test" or "all" features must be enabled
/// #[cfg(any(feature = "test", feature = "all"))]
/// {
///     use cs_utils::test::implements_clone;
///     
///     // do not derive clone
///     struct TestStruct {}
/// 
///     // does not compile
///     implements_clone(TestStruct {});
/// }
/// ```
pub fn implements_clone<T: Clone>(item: T) -> T {
    return item;
}
